/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.asf.DirectoryScanner;
import org.osgi.service.prefs.BackingStoreException;

public class PrefsInitializer
extends AbstractPreferenceInitializer {
    public static final String PREF_SHOW_PACKAGE_OUTPUT_PATH = "showPackageOutputPath";
    public static final String PREF_SHOW_FULL_FILESET_ROOT_DIR = "showFullFilesetRootDir";
    public static final String PREF_SHOW_PROJECT_ROOT = "showProjectRoot";
    public static final String PREF_SHOW_ALL_PROJECTS = "showAllProjects";
    public static final String PREF_SHOW_BUILD_ERROR_DIALOG = "showBuildErrorDialog";
    public static final String PREF_ALWAYS_SHOW_PROJECT_EXPLORER_NODE = "alwaysShowProjectExplorerNode";
    public static final String PREF_USE_DEFAULT_EXCLUDES = "useDefaultExcludes";
    public static final String PREF_DEFAULT_EXCLUDE_LIST = "defaultExcludesList";
    public static final ArrayList<IArchivesPreferenceListener> listeners = new ArrayList();

    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = new DefaultScope().getNode("org.jboss.ide.eclipse.archives.ui");
        prefs.putBoolean(PREF_SHOW_FULL_FILESET_ROOT_DIR, true);
        prefs.putBoolean(PREF_SHOW_PACKAGE_OUTPUT_PATH, true);
        prefs.putBoolean(PREF_SHOW_PROJECT_ROOT, true);
        prefs.putBoolean(PREF_SHOW_ALL_PROJECTS, false);
        prefs.putBoolean(PREF_SHOW_BUILD_ERROR_DIALOG, true);
        prefs.putBoolean(PREF_ALWAYS_SHOW_PROJECT_EXPLORER_NODE, false);
        prefs.putBoolean(PREF_USE_DEFAULT_EXCLUDES, true);
        prefs.put(PREF_DEFAULT_EXCLUDE_LIST, DirectoryScanner.implodeStrings((String[])DirectoryScanner.getDefaultExcludes()));
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public static void setBoolean(String key, boolean val) {
        PrefsInitializer.setBoolean(key, val, null);
    }

    public static void setBoolean(String key, boolean val, IAdaptable adaptable) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.ui", key);
        if (adaptable != null) {
            IResource project = (IResource)adaptable.getAdapter(IResource.class);
            try {
                if (project != null && project.getPersistentProperty(name) != null) {
                    project.setPersistentProperty(name, new Boolean(val).toString());
                    return;
                }
            }
            catch (CoreException coreException) {}
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.archives.ui");
        prefs.putBoolean(key, val);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        PrefsInitializer.fireChanged(key, val);
    }

    public static void setString(String key, String val) {
        PrefsInitializer.setString(key, val, null);
    }

    public static void setString(String key, String val, IAdaptable adaptable) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.ui", key);
        if (adaptable != null) {
            IResource project = (IResource)adaptable.getAdapter(IResource.class);
            try {
                if (project != null) {
                    project.setPersistentProperty(name, val);
                    return;
                }
            }
            catch (CoreException coreException) {}
        }
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.archives.ui");
        prefs.put(key, val);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        PrefsInitializer.fireChanged(key, val);
    }

    protected static void fireChanged(String key, boolean val) {
        Iterator<IArchivesPreferenceListener> i = listeners.iterator();
        while (i.hasNext()) {
            i.next().preferenceChanged(key, val);
        }
    }

    protected static void fireChanged(String key, String val) {
        Iterator<IArchivesPreferenceListener> i = listeners.iterator();
        while (i.hasNext()) {
            i.next().preferenceChanged(key, val);
        }
    }

    public static void addListener(IArchivesPreferenceListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeListener(IArchivesPreferenceListener listener) {
        listeners.remove(listener);
    }

    public static boolean getBoolean(String key) {
        return PrefsInitializer.getBoolean(key, null, true);
    }

    public static boolean getBoolean(String key, IAdaptable adaptable, boolean effective) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.ui", key);
        if (adaptable != null) {
            IResource project = (IResource)adaptable.getAdapter(IResource.class);
            boolean specific = ArchivesCore.getInstance().getPreferenceManager().areProjectSpecificPrefsEnabled(project.getLocation());
            if (specific) {
                try {
                    if (project != null && project.getPersistentProperty(name) != null) {
                        return Boolean.parseBoolean(project.getPersistentProperty(name));
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        boolean defaultVal = new DefaultScope().getNode("org.jboss.ide.eclipse.archives.ui").getBoolean(key, false);
        return new InstanceScope().getNode("org.jboss.ide.eclipse.archives.ui").getBoolean(key, defaultVal);
    }

    public static String getString(String key) {
        return PrefsInitializer.getString(key, null, true);
    }

    public static String getString(String key, IAdaptable adaptable, boolean effective) {
        QualifiedName name = new QualifiedName("org.jboss.ide.eclipse.archives.ui", key);
        if (adaptable != null) {
            IResource project = (IResource)adaptable.getAdapter(IResource.class);
            boolean specific = ArchivesCore.getInstance().getPreferenceManager().areProjectSpecificPrefsEnabled(project.getLocation());
            if (specific) {
                try {
                    if (project != null && project.getPersistentProperty(name) != null) {
                        return project.getPersistentProperty(name);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        String defaultVal = new DefaultScope().getNode("org.jboss.ide.eclipse.archives.ui").get(key, "");
        return new InstanceScope().getNode("org.jboss.ide.eclipse.archives.ui").get(key, defaultVal);
    }

    public static interface IArchivesPreferenceListener {
        public void preferenceChanged(String var1, boolean var2);

        public void preferenceChanged(String var1, String var2);
    }
}

