/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.preferences;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.asf.DirectoryScanner;
import org.jboss.ide.eclipse.archives.core.model.IPreferenceManager;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;

public class MainPreferencePage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private Button showPackageOutputPath;
    private Button showFullFilesetRootDir;
    private Button showProjectRoot;
    private Button showAllProjects;
    private Button automaticBuilder;
    private Button showErrorDialog;
    private Button overrideButton;
    private Button showNodeOnAllProjects;
    private Button enableDefaultExcludes;
    private Text defaultExcludes;
    private Group corePrefGroup;
    private Group viewPrefGroup;
    private Group packageExplorerGroup;
    private Group filesetGroup;
    private Composite overrideComp;
    private Link fChangeWorkspaceSettings;

    public MainPreferencePage() {
        this.setTitle(ArchivesUIMessages.PreferencePageTitle);
        this.setImageDescriptor(ArchivesSharedImages.getImageDescriptor("icons/jar_obj.gif"));
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        main.setLayout((Layout)gl);
        this.createOverridePrefs(main);
        this.createCorePrefs(main);
        this.createViewPrefs(main);
        this.createProjectExplorerPrefs(main);
        this.createFilesetPrefs(main);
        this.fillValues();
        return main;
    }

    public IPath getResourceLocationIfExists() {
        IAdaptable el = this.getElement();
        return el == null ? null : ((IResource)el.getAdapter(IResource.class)).getLocation();
    }

    public IPreferenceManager getPrefManager() {
        return ArchivesCore.getInstance().getPreferenceManager();
    }

    protected void fillValues() {
        if (this.getResourceLocationIfExists() != null) {
            this.overrideButton.setSelection(this.getPrefManager().areProjectSpecificPrefsEnabled(this.getResourceLocationIfExists()));
        }
        this.automaticBuilder.setSelection(this.getPrefManager().isArchivesBuilderEnabled(this.getResourceLocationIfExists()));
        this.showErrorDialog.setSelection(PrefsInitializer.getBoolean("showBuildErrorDialog", this.getElement(), true));
        this.showAllProjects.setSelection(PrefsInitializer.getBoolean("showAllProjects", this.getElement(), false));
        this.showPackageOutputPath.setSelection(PrefsInitializer.getBoolean("showPackageOutputPath", this.getElement(), false));
        this.showFullFilesetRootDir.setSelection(PrefsInitializer.getBoolean("showFullFilesetRootDir", this.getElement(), false));
        this.showProjectRoot.setSelection(PrefsInitializer.getBoolean("showProjectRoot", this.getElement(), false));
        this.enableDefaultExcludes.setSelection(PrefsInitializer.getBoolean("useDefaultExcludes", this.getElement(), false));
        this.showNodeOnAllProjects.setSelection(PrefsInitializer.getBoolean("alwaysShowProjectExplorerNode", this.getElement(), false));
        this.defaultExcludes.setText(PrefsInitializer.getString("defaultExcludesList", this.getElement(), true));
        this.showAllProjects.setEnabled(this.showProjectRoot.getSelection());
        if (!this.showProjectRoot.getSelection()) {
            this.showAllProjects.setSelection(false);
        }
        if (this.getElement() != null) {
            this.setWidgetsEnabled(this.overrideButton.getSelection());
        }
    }

    protected void createOverridePrefs(Composite main) {
        if (this.getResourceLocationIfExists() != null) {
            this.overrideComp = new Composite(main, 0);
            this.overrideComp.setLayout((Layout)new FormLayout());
            this.overrideComp.setLayoutData((Object)new GridData(768));
            this.overrideButton = new Button(this.overrideComp, 32);
            this.overrideButton.setText(ArchivesUIMessages.ProjectSpecificSettings);
            this.overrideButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    MainPreferencePage.this.setWidgetsEnabled(MainPreferencePage.this.overrideButton.getSelection());
                }
            });
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 5);
            fd.left = new FormAttachment(0, 5);
            this.overrideButton.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment((Control)this.overrideButton, 5);
            fd.right = new FormAttachment(100, -5);
            fd.right.alignment = 131072;
            Composite tmp = new Composite(this.overrideComp, 0);
            tmp.setLayoutData((Object)fd);
            tmp.setLayout((Layout)new GridLayout(1, true));
            this.fChangeWorkspaceSettings = this.createLink(tmp, "Configure Workspace Settings...");
            this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        }
    }

    private void openGlobalPrefs() {
        String id = "org.jboss.ide.eclipse.archives.ui.archivesPreferencePage";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)this.getElement()).open();
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 2048);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MainPreferencePage.this.openGlobalPrefs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MainPreferencePage.this.openGlobalPrefs();
            }
        });
        return link;
    }

    protected void setWidgetsEnabled(boolean val) {
        this.showPackageOutputPath.setEnabled(val);
        this.showProjectRoot.setEnabled(val);
        this.showFullFilesetRootDir.setEnabled(val);
        if (this.showProjectRoot.getSelection()) {
            this.showAllProjects.setEnabled(val);
        }
        this.automaticBuilder.setEnabled(val);
        this.showErrorDialog.setEnabled(val);
        this.enableDefaultExcludes.setEnabled(val);
        this.defaultExcludes.setEnabled(val);
        this.showNodeOnAllProjects.setEnabled(val);
    }

    protected void createCorePrefs(Composite main) {
        this.corePrefGroup = new Group(main, 0);
        this.corePrefGroup.setText(ArchivesUIMessages.CorePreferences);
        this.corePrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.corePrefGroup.setLayoutData((Object)new GridData(768));
        this.automaticBuilder = new Button((Composite)this.corePrefGroup, 32);
        this.automaticBuilder.setText(ArchivesUIMessages.EnableIncrementalBuilder);
        this.showErrorDialog = new Button((Composite)this.corePrefGroup, 32);
        this.showErrorDialog.setText(ArchivesUIMessages.ShowBuildErrorDialog);
    }

    protected void createProjectExplorerPrefs(Composite main) {
        this.packageExplorerGroup = new Group(main, 0);
        this.packageExplorerGroup.setText(ArchivesUIMessages.ProjectExplorerPreferences);
        this.packageExplorerGroup.setLayout((Layout)new GridLayout(1, false));
        this.packageExplorerGroup.setLayoutData((Object)new GridData(768));
        this.showNodeOnAllProjects = new Button((Composite)this.packageExplorerGroup, 32);
        this.showNodeOnAllProjects.setText(ArchivesUIMessages.EnableNodeAlways);
    }

    protected void createFilesetPrefs(Composite main) {
        this.filesetGroup = new Group(main, 0);
        this.filesetGroup.setText(ArchivesUIMessages.FilesetPreferences);
        this.filesetGroup.setLayout((Layout)new FormLayout());
        this.filesetGroup.setLayoutData((Object)new GridData(768));
        this.enableDefaultExcludes = new Button((Composite)this.filesetGroup, 32);
        this.enableDefaultExcludes.setText(ArchivesUIMessages.EnableDefaultExcludes);
        this.defaultExcludes = new Text((Composite)this.filesetGroup, 2052);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        this.enableDefaultExcludes.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.top = new FormAttachment((Control)this.enableDefaultExcludes, 5);
        fd.right = new FormAttachment(0, 350);
        fd.bottom = new FormAttachment(100, -10);
        this.defaultExcludes.setLayoutData((Object)fd);
    }

    protected void createViewPrefs(Composite main) {
        this.viewPrefGroup = new Group(main, 0);
        this.viewPrefGroup.setText(ArchivesUIMessages.ProjectPackagesView);
        this.viewPrefGroup.setLayout((Layout)new GridLayout(1, false));
        this.viewPrefGroup.setLayoutData((Object)new GridData(768));
        this.showPackageOutputPath = new Button((Composite)this.viewPrefGroup, 32);
        this.showPackageOutputPath.setText(ArchivesUIMessages.ShowOutputPath);
        this.showFullFilesetRootDir = new Button((Composite)this.viewPrefGroup, 32);
        this.showFullFilesetRootDir.setText(ArchivesUIMessages.ShowRootDirectory);
        this.showProjectRoot = new Button((Composite)this.viewPrefGroup, 32);
        this.showProjectRoot.setText(ArchivesUIMessages.ShowRootProject);
        this.showProjectRoot.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                MainPreferencePage.this.showAllProjects.setEnabled(MainPreferencePage.this.showProjectRoot.getSelection());
                if (!MainPreferencePage.this.showProjectRoot.getSelection()) {
                    MainPreferencePage.this.showAllProjects.setSelection(false);
                }
            }
        });
        this.showAllProjects = new Button((Composite)this.viewPrefGroup, 32);
        this.showAllProjects.setText(ArchivesUIMessages.ShowAllProjects);
        this.showAllProjects.setEnabled(this.showProjectRoot.getSelection());
        if (!this.showProjectRoot.getSelection()) {
            this.showAllProjects.setSelection(false);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        this.automaticBuilder.setSelection(true);
        this.showErrorDialog.setSelection(true);
        this.showPackageOutputPath.setSelection(true);
        this.showFullFilesetRootDir.setSelection(true);
        this.showProjectRoot.setSelection(true);
        this.showAllProjects.setSelection(false);
        this.showNodeOnAllProjects.setSelection(false);
        this.enableDefaultExcludes.setSelection(false);
        this.defaultExcludes.setText(DirectoryScanner.implodeStrings((String[])DirectoryScanner.getDefaultExcludes()));
        if (this.getResourceLocationIfExists() != null) {
            this.overrideButton.setSelection(false);
            this.setWidgetsEnabled(this.overrideButton.getSelection());
        } else {
            this.setWidgetsEnabled(true);
        }
    }

    public boolean performOk() {
        if (this.getResourceLocationIfExists() != null) {
            this.getPrefManager().setProjectSpecificPrefsEnabled(this.getResourceLocationIfExists(), this.overrideButton.getSelection());
        }
        this.getPrefManager().setArchivesBuilderEnabled(this.getResourceLocationIfExists(), this.automaticBuilder.getSelection());
        PrefsInitializer.setBoolean("showBuildErrorDialog", this.showErrorDialog.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("showPackageOutputPath", this.showPackageOutputPath.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("showFullFilesetRootDir", this.showFullFilesetRootDir.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("showProjectRoot", this.showProjectRoot.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("showAllProjects", this.showAllProjects.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("alwaysShowProjectExplorerNode", this.showNodeOnAllProjects.getSelection(), this.getElement());
        PrefsInitializer.setBoolean("useDefaultExcludes", this.enableDefaultExcludes.getSelection(), this.getElement());
        PrefsInitializer.setString("defaultExcludesList", this.defaultExcludes.getText(), this.getElement());
        return true;
    }
}

