/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.test.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.core.util.ServerCreationUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;
import org.jboss.ide.eclipse.as.test.ASTest;
import org.jboss.ide.eclipse.as.test.util.IOUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.tools.test.util.JobUtils;
import org.osgi.framework.Bundle;

public class ServerRuntimeUtils
extends TestCase {
    public static String BUNDLE_NAME = "org.jboss.ide.eclipse.as.test";
    public static final IVMInstall VM_INSTALL = JavaRuntime.getDefaultVMInstall();
    public static final String DEFAULT_CONFIG = "default";
    public static final String twiddle_suffix = ".mf.twiddle.jar";
    public static final String twiddle_3_2_8 = "3.2.8.mf.twiddle.jar";
    public static final String twiddle_4_0_5 = "4.0.5.mf.twiddle.jar";
    public static final String twiddle_4_2_3 = "4.2.3.mf.twiddle.jar";
    public static final String twiddle_5_0_0 = "5.0.0.mf.twiddle.jar";
    public static final String twiddle_5_0_1 = "5.0.1.mf.twiddle.jar";
    public static final String twiddle_5_1_0 = "5.1.0.mf.twiddle.jar";
    public static final String twiddle_6_0_0 = "6.0.0.mf.twiddle.jar";
    public static final String as_server_7_0_jar = "7.0.0.mf.jboss-as-server.jar";
    public static final String as_server_7_1_jar = "7.1.0.mf.jboss-as-server.jar";
    public static final String twiddle_eap_4_3 = "eap4.3.mf.twiddle.jar";
    public static final String twiddle_eap_5_0 = "eap5.0.mf.twiddle.jar";
    public static final String eap_server_6_0_jar = "eap6.0.0.mf.jboss-as-server.jar";
    public static final String run_jar = "run.jar";
    public static final String service_xml = "service.xml";
    public static final IPath mockedServers = ASTest.getDefault().getStateLocation().append("mockedServers");
    public static HashMap<String, String> asSystemJar = new HashMap();
    public static HashMap<String, String> serverRuntimeMap = new HashMap();
    public static final int DEFAULT_STARTUP_TIME = 150000;
    public static final int DEFAULT_SHUTDOWN_TIME = 90000;

    static {
        asSystemJar.put("org.jboss.ide.eclipse.as.32", twiddle_3_2_8);
        asSystemJar.put("org.jboss.ide.eclipse.as.40", twiddle_4_0_5);
        asSystemJar.put("org.jboss.ide.eclipse.as.42", twiddle_4_2_3);
        asSystemJar.put("org.jboss.ide.eclipse.as.50", twiddle_5_0_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.51", twiddle_5_1_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.60", twiddle_6_0_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.70", as_server_7_0_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.71", as_server_7_1_jar);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.43", twiddle_eap_4_3);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.50", twiddle_eap_5_0);
        asSystemJar.put("org.jboss.ide.eclipse.as.eap.60", eap_server_6_0_jar);
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.32", "org.jboss.ide.eclipse.as.runtime.32");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.40", "org.jboss.ide.eclipse.as.runtime.40");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.42", "org.jboss.ide.eclipse.as.runtime.42");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.50", "org.jboss.ide.eclipse.as.runtime.50");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.51", "org.jboss.ide.eclipse.as.runtime.51");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.60", "org.jboss.ide.eclipse.as.runtime.60");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.70", "org.jboss.ide.eclipse.as.runtime.70");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.43", "org.jboss.ide.eclipse.as.runtime.eap.43");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.50", "org.jboss.ide.eclipse.as.runtime.eap.50");
        serverRuntimeMap.put("org.jboss.ide.eclipse.as.eap.60", "org.jboss.ide.eclipse.as.runtime.eap.60");
    }

    public static IServer createMockDeployOnlyServer() throws CoreException {
        return ServerRuntimeUtils.createMockDeployOnlyServer(ServerRuntimeUtils.getDeployFolder(), ServerRuntimeUtils.getTmpDeployFolder());
    }

    public static IServer createMockJBoss7Server() throws CoreException {
        return ServerRuntimeUtils.createMockJBoss7Server(ServerRuntimeUtils.getDeployFolder(), ServerRuntimeUtils.getTmpDeployFolder());
    }

    private static String getDeployFolder() {
        return ServerRuntimeUtils.getBaseDir().append(ServerRuntimeUtils.getRandomString()).append("deploy").toOSString();
    }

    private static String getTmpDeployFolder() {
        return ServerRuntimeUtils.getBaseDir().append(ServerRuntimeUtils.getRandomString()).append("tmpDeploy").toOSString();
    }

    public static IPath getBaseDir() {
        return ASTest.getDefault().getStateLocation().append("testDeployments");
    }

    private static String getRandomString() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static IServer createMockJBoss7Server(String deployLocation, String tempDeployLocation) throws CoreException {
        return ServerRuntimeUtils.createMockJBoss7Server("/", deployLocation, tempDeployLocation);
    }

    public static IServer createMockJBoss7Server(String rtLoc, String deployLocation, String tempDeployLocation) throws CoreException {
        IRuntime runtime = RuntimeUtils.createRuntime((String)"org.jboss.ide.eclipse.as.runtime.70", (String)rtLoc, (String)DEFAULT_CONFIG);
        IServer s = ServerCreationUtils.createServer2((IRuntime)runtime, (String)"org.jboss.ide.eclipse.as.70");
        IServerWorkingCopy swc = s.createWorkingCopy();
        swc.setServerConfiguration(null);
        swc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", deployLocation);
        swc.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", tempDeployLocation);
        IServer server = swc.save(true, null);
        return server;
    }

    public static IServer createMockDeployOnlyServer(String deployLocation, String tempDeployLocation) throws CoreException {
        return ServerRuntimeUtils.createMockDeployOnlyServer(deployLocation, tempDeployLocation, "testRuntime", "testServer");
    }

    public static IServer createMockDeployOnlyServer(String deployLocation, String tempDeployLocation, String rtName, String serverName) throws CoreException {
        return ServerCreationUtils.createDeployOnlyServer((String)deployLocation, (String)tempDeployLocation, (String)rtName, (String)serverName);
    }

    public static IServer createMockServerWithRuntime(String serverType, String name, String config) {
        try {
            IServerType type = ServerCore.findServerType((String)serverType);
            if (ServerUtil.isJBoss7((IServerType)type)) {
                return ServerRuntimeUtils.createMockJBoss7Server();
            }
            IPath serverDir = ServerRuntimeUtils.createAS6AndBelowMockServerDirectory(name, asSystemJar.get(serverType), config);
            return ServerRuntimeUtils.createServer(serverRuntimeMap.get(serverType), serverType, serverDir.toOSString(), config);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IServer create32Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.32", "org.jboss.ide.eclipse.as.32", ASTest.JBOSS_AS_32_HOME, DEFAULT_CONFIG);
    }

    public static IServer create40Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.40", "org.jboss.ide.eclipse.as.40", ASTest.JBOSS_AS_40_HOME, DEFAULT_CONFIG);
    }

    public static IServer create42Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.42", "org.jboss.ide.eclipse.as.42", ASTest.JBOSS_AS_42_HOME, DEFAULT_CONFIG);
    }

    public static IServer create50Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.50", "org.jboss.ide.eclipse.as.50", ASTest.JBOSS_AS_50_HOME, DEFAULT_CONFIG);
    }

    public static IServer create51Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.51", "org.jboss.ide.eclipse.as.51", ASTest.JBOSS_AS_51_HOME, DEFAULT_CONFIG);
    }

    public static IServer create60Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.60", "org.jboss.ide.eclipse.as.60", ASTest.JBOSS_AS_60_HOME, DEFAULT_CONFIG);
    }

    public static IServer create70Server() throws CoreException {
        return ServerRuntimeUtils.createServer("org.jboss.ide.eclipse.as.runtime.70", "org.jboss.ide.eclipse.as.70", ASTest.JBOSS_AS_70_HOME, DEFAULT_CONFIG);
    }

    public static IServer createServer(String runtimeID, String serverID, String location, String configuration) throws CoreException {
        IRuntime runtime = RuntimeUtils.createRuntime((String)runtimeID, (String)location, (String)configuration);
        return ServerCreationUtils.createServer2((IRuntime)runtime, (String)serverID);
    }

    public static IServer createServer(String runtimeID, String serverID, String location, String configuration, IVMInstall install) throws CoreException {
        IRuntime runtime = RuntimeUtils.createRuntime((String)runtimeID, (String)location, (String)configuration);
        return ServerCreationUtils.createServer2((IRuntime)runtime, (String)serverID);
    }

    public static IRuntime createRuntime(String runtimeId, String homeDir, String config) throws CoreException {
        return RuntimeUtils.createRuntime((String)runtimeId, (String)homeDir, (String)config, (IVMInstall)VM_INSTALL);
    }

    public static IRuntime createRuntime(String runtimeId, String homeDir, String config, IVMInstall install) throws CoreException {
        ServerRuntimeUtils.assertTrue((String)("path \"" + homeDir + "\" does not exist"), (boolean)new Path(homeDir).toFile().exists());
        return RuntimeUtils.createRuntime((String)runtimeId, (String)homeDir, (String)config, (IVMInstall)install);
    }

    public static IRuntime createRuntime(String runtimeId, String homeDir, String config, IExecutionEnvironment environment) throws CoreException {
        ServerRuntimeUtils.assertTrue((String)("path \"" + homeDir + "\" does not exist"), (boolean)new Path(homeDir).toFile().exists());
        return RuntimeUtils.createRuntime((String)runtimeId, (String)homeDir, (String)config);
    }

    public static void deleteAllServers() throws CoreException {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            servers[i].delete();
            ++i;
        }
    }

    public static void deleteAllRuntimes() throws CoreException {
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            runtimes[i].delete();
            ++i;
        }
    }

    public static IPath createAS6AndBelowMockServerDirectory(String name, String twiddleJar, String configurationName) {
        IPath loc = mockedServers.append(name);
        try {
            loc.toFile().mkdirs();
            loc.append("bin").toFile().mkdirs();
            loc.append("server").toFile().mkdirs();
            loc.append("server").append(configurationName).toFile().mkdirs();
            IPath configConf = loc.append("server").append(configurationName).append("conf");
            configConf.toFile().mkdirs();
            File twiddleLoc = ServerRuntimeUtils.getFileLocation("serverMock/" + twiddleJar);
            FileUtil.fileSafeCopy((File)twiddleLoc, (File)loc.append("bin").append("twiddle.jar").toFile());
            File runJar = ServerRuntimeUtils.getFileLocation("serverMock/run.jar");
            FileUtil.fileSafeCopy((File)runJar, (File)loc.append("bin").append(run_jar).toFile());
            File serviceXml = ServerRuntimeUtils.getFileLocation("serverMock/jboss-service.xml");
            FileUtil.fileSafeCopy((File)serviceXml, (File)configConf.append("jboss-service.xml").toFile());
            return loc;
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
            return null;
        }
    }

    public static IPath createAS7StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        try {
            loc.toFile().mkdirs();
            IPath serverJarBelongs = loc.append("modules/org/jboss/as/server/main");
            serverJarBelongs.toFile().mkdirs();
            File serverJarLoc = ServerRuntimeUtils.getFileLocation("serverMock/" + serverJar);
            FileUtil.fileSafeCopy((File)serverJarLoc, (File)serverJarBelongs.append("anything.jar").toFile());
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
            return null;
        }
        return loc;
    }

    public static IPath createEAP6StyleMockServerDirectory(String name, String serverTypeId, String serverJar) {
        IPath loc = mockedServers.append(name);
        try {
            loc.toFile().mkdirs();
            IPath productConf = loc.append("bin/product.conf");
            loc.append("bin").toFile().mkdirs();
            IOUtil.setContents(productConf.toFile(), "slot=eap");
            loc.append("modules/org/jboss/as/product/eap/dir/META-INF").toFile().mkdirs();
            IPath manifest = loc.append("modules/org/jboss/as/product/eap/dir/META-INF/MANIFEST.MF");
            String manString = "JBoss-Product-Release-Name: EAP\nJBoss-Product-Release-Version: 6.0.0.Alpha\nJBoss-Product-Console-Slot: eap";
            IOUtil.setContents(manifest.toFile(), manString);
        }
        catch (CoreException coreException) {
            FileUtil.completeDelete((File)loc.toFile());
            return null;
        }
        catch (IOException iOException) {
            FileUtil.completeDelete((File)loc.toFile());
            return null;
        }
        return loc;
    }

    protected static File getFileLocation(String path) throws CoreException {
        Bundle bundle = Platform.getBundle((String)BUNDLE_NAME);
        URL url = null;
        try {
            url = FileLocator.resolve((URL)bundle.getEntry(path));
        }
        catch (IOException e) {
            String msg = "Cannot find file " + path + " in " + BUNDLE_NAME;
            Status status = new Status(4, "org.jboss.ide.eclipse.as.test", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        String location = url.getFile();
        return new File(location);
    }

    public static String getDeployRoot(IServer server) {
        IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)server);
        return ds.getDeployFolder();
    }

    public static IServer setServerAttribute(IServer server, String attribute, boolean value) {
        ServerAttributeHelper helper = new ServerAttributeHelper(server, server.createWorkingCopy());
        helper.setAttribute(attribute, value);
        return helper.save();
    }

    public static IServer addModule(IServer server, IModule module) throws CoreException {
        IServerWorkingCopy copy = server.createWorkingCopy();
        copy.modifyModules(new IModule[]{module}, new IModule[0], (IProgressMonitor)new NullProgressMonitor());
        return copy.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IServer removeModule(IServer server, IModule module) throws CoreException {
        IServerWorkingCopy copy = server.createWorkingCopy();
        copy.modifyModules(new IModule[0], new IModule[]{module}, (IProgressMonitor)new NullProgressMonitor());
        return copy.save(false, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IStatus publish(IServer server) throws CoreException {
        return ServerRuntimeUtils.publish(1, server);
    }

    public static IStatus publishFull(IServer server) throws CoreException {
        return ServerRuntimeUtils.publish(2, server);
    }

    public static IStatus publish(int type, IServer server) throws CoreException {
        IStatus s = server.publish(type, (IProgressMonitor)new NullProgressMonitor());
        JobUtils.waitForIdle((long)1000L);
        return s;
    }

    public static IServer setZipped(IServer server, boolean val) {
        return ServerRuntimeUtils.setServerAttribute(server, "org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", val);
    }

    public static void startup(IServer server) {
        ServerRuntimeUtils.startup(server, 150000);
    }

    public static void startup(final IServer currentServer, int maxWait) {
        long finishTime = new Date().getTime() + (long)maxWait;
        final StatusWrapper opWrapper = new StatusWrapper();
        final IServer.IOperationListener listener = new IServer.IOperationListener(){

            public void done(IStatus result) {
                opWrapper.setStatus(result);
            }
        };
        ErrorStreamListener streamListener = new ErrorStreamListener();
        Thread startThread = new Thread(){

            public void run() {
                currentServer.start("run", listener);
            }
        };
        startThread.start();
        boolean addedStream = false;
        while (finishTime > new Date().getTime() && opWrapper.getStatus() == null) {
            IStreamMonitor mon;
            if (!addedStream && (mon = ServerRuntimeUtils.getStreamMonitor(currentServer)) != null) {
                mon.addListener((IStreamListener)streamListener);
                addedStream = true;
            }
            try {
                Display.getDefault().readAndDispatch();
            }
            catch (SWTException sWTException) {}
        }
        try {
            ServerRuntimeUtils.assertTrue((String)"Startup has taken longer than what is expected for a default startup", (finishTime >= new Date().getTime() ? 1 : 0) != 0);
            ServerRuntimeUtils.assertNotNull((String)"Startup never finished", (Object)opWrapper.getStatus());
            ServerRuntimeUtils.assertFalse((String)"Startup failed", (opWrapper.getStatus().getSeverity() == 4 ? 1 : 0) != 0);
            ServerRuntimeUtils.assertFalse((String)"Startup had System.error output", (boolean)streamListener.hasError());
        }
        catch (AssertionFailedError afe) {
            currentServer.stop(true);
            throw afe;
        }
        if (ServerRuntimeUtils.getStreamMonitor(currentServer) != null) {
            ServerRuntimeUtils.getStreamMonitor(currentServer).removeListener((IStreamListener)streamListener);
        }
    }

    public static void shutdown(IServer currentServer) {
        ServerRuntimeUtils.shutdown(currentServer, 90000);
    }

    public static void shutdown(final IServer currentServer, int maxWait) {
        long finishTime = new Date().getTime() + (long)maxWait;
        final StatusWrapper opWrapper = new StatusWrapper();
        final IServer.IOperationListener listener = new IServer.IOperationListener(){

            public void done(IStatus result) {
                opWrapper.setStatus(result);
            }
        };
        ErrorStreamListener streamListener = new ErrorStreamListener();
        if (ServerRuntimeUtils.getStreamMonitor(currentServer) != null) {
            ServerRuntimeUtils.getStreamMonitor(currentServer).addListener((IStreamListener)streamListener);
        }
        Thread stopThread = new Thread(){

            public void run() {
                currentServer.stop(false, listener);
            }
        };
        stopThread.start();
        while (finishTime > new Date().getTime() && opWrapper.getStatus() == null) {
            try {
                Display.getDefault().readAndDispatch();
            }
            catch (SWTException sWTException) {}
        }
        try {
            ServerRuntimeUtils.assertTrue((String)"Startup has taken longer than what is expected for a default startup", (finishTime >= new Date().getTime() ? 1 : 0) != 0);
            ServerRuntimeUtils.assertNotNull((String)"Startup never finished", (Object)opWrapper.getStatus());
            ServerRuntimeUtils.assertFalse((String)"Startup had System.error output", (boolean)streamListener.hasError());
        }
        catch (AssertionFailedError afe) {
            currentServer.stop(true);
            throw afe;
        }
    }

    protected static IStreamMonitor getStreamMonitor(IServer server) {
        IProcess process;
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((IServerAttributes)server);
        beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process");
        if (beh != null && (process = (IProcess)beh.getSharedData("AbstractStartJavaServerLaunchDelegate.Process")) != null) {
            return process.getStreamsProxy().getOutputStreamMonitor();
        }
        return null;
    }

    protected static class ErrorStreamListener
    implements IStreamListener {
        protected boolean errorFound = false;
        String entireLog = "";

        protected ErrorStreamListener() {
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            this.entireLog = String.valueOf(this.entireLog) + text;
        }

        public boolean hasError() {
            return this.errorFound;
        }
    }

    public static class StatusWrapper {
        protected IStatus status;

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus s) {
            this.status = s;
        }
    }
}

