/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.JMXActivator;
import org.jboss.tools.jmx.core.JMXCoreMessages;

public class ExtensionManager {
    public static final String MBEAN_CONNECTION = "org.jboss.tools.jmx.core.MBeanServerConnectionProvider";
    public static final String CLASS = "class";
    private static HashMap<String, IConnectionProvider> providers;

    public static IConnectionProvider[] getProviders() {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        ArrayList<IConnectionProvider> ret = new ArrayList<IConnectionProvider>();
        ret.addAll(providers.values());
        Collections.sort(ret, new Comparator<IConnectionProvider>(){

            @Override
            public int compare(IConnectionProvider arg0, IConnectionProvider arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        });
        return ret.toArray(new IConnectionProvider[ret.size()]);
    }

    public static IConnectionProvider getProvider(String id) {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        return providers.get(id);
    }

    public static IConnectionWrapper[] getAllConnections() {
        if (providers == null) {
            ExtensionManager.loadExtensions();
        }
        ArrayList<IConnectionWrapper> l = new ArrayList<IConnectionWrapper>();
        Iterator<IConnectionProvider> i = providers.values().iterator();
        while (i.hasNext()) {
            l.addAll(Arrays.asList(i.next().getConnections()));
        }
        return l.toArray(new IConnectionWrapper[l.size()]);
    }

    public static void loadExtensions() {
        HashMap<String, IConnectionProvider> tmp = new HashMap<String, IConnectionProvider>();
        IExtension[] extensions = ExtensionManager.findExtension(MBEAN_CONNECTION);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                Status s;
                try {
                    IConnectionProvider o = (IConnectionProvider)elements[j].createExecutableExtension(CLASS);
                    tmp.put(o.getId(), o);
                }
                catch (InvalidRegistryObjectException e) {
                    s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.ExtensionManagerError1, (Throwable)e);
                    JMXActivator.log((IStatus)s);
                }
                catch (CoreException e) {
                    s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.ExtensionManagerError1, (Throwable)e);
                    JMXActivator.log((IStatus)s);
                }
                ++j;
            }
            ++i;
        }
        providers = tmp;
    }

    private static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    public static void addConnectionProviderListener(IConnectionProviderListener listener) {
        IConnectionProvider[] providers2 = ExtensionManager.getProviders();
        int i = 0;
        while (i < providers2.length) {
            providers2[i].addListener(listener);
            ++i;
        }
    }

    public static void removeConnectionProviderListener(IConnectionProviderListener listener) {
        IConnectionProvider[] providers2 = ExtensionManager.getProviders();
        int i = 0;
        while (i < providers2.length) {
            providers2[i].removeListener(listener);
            ++i;
        }
    }
}

