/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.ui;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.rse.ui.RSEBrowseBehavior;
import org.jboss.ide.eclipse.as.rse.ui.RSEDeploymentPreferenceComposite;
import org.jboss.ide.eclipse.as.rse.ui.RSEUIMessages;
import org.jboss.ide.eclipse.as.ui.UIUtil;
import org.jboss.ide.eclipse.as.ui.editor.IDeploymentTypeUI;
import org.jboss.ide.eclipse.as.ui.editor.ServerModeSectionComposite;

public class JBoss7RSEDeploymentPrefComposite
extends RSEDeploymentPreferenceComposite {
    private Text rseServerHome;
    private Button rseBrowse;
    private Text rseBaseDirText;
    private Button rseBaseDirBrowse;
    private Text rseConfigFileText;
    private Button rseConfigFileBrowse;
    private ControlDecoration serverHomeDecoration;

    public JBoss7RSEDeploymentPrefComposite(Composite parent, int style, IDeploymentTypeUI.IServerModeUICallback callback) {
        super(parent, style, callback);
        this.validateWidgets(false);
    }

    @Override
    protected void createRSEWidgets(Composite child) {
        Label serverHomeLabel = new Label((Composite)this, 0);
        serverHomeLabel.setText(RSEUIMessages.REMOTE_SERVER_HOME_LABEL);
        this.rseBrowse = new Button((Composite)this, 0);
        this.rseBrowse.setText(RSEUIMessages.BROWSE);
        this.rseBrowse.setLayoutData((Object)UIUtil.createFormData2((Object)child, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteHomeBrowseClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteHomeBrowseClicked();
            }
        });
        this.rseServerHome = new Text((Composite)this, 2052);
        serverHomeLabel.setLayoutData((Object)UIUtil.createFormData2((Object)child, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.rseServerHome.setLayoutData((Object)UIUtil.createFormData2((Object)child, (int)5, null, (int)0, (Object)serverHomeLabel, (int)10, (Object)this.rseBrowse, (int)-5));
        this.rseServerHome.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", ""));
        this.serverHomeDecoration = new ControlDecoration((Control)this.rseServerHome, 0x1000000);
        this.rseServerHome.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.serverHomeChanged();
            }
        });
        Label baseDirLabel = new Label((Composite)this, 0);
        baseDirLabel.setText(RSEUIMessages.REMOTE_BASE_DIR_LABEL);
        this.rseBaseDirBrowse = new Button((Composite)this, 0);
        this.rseBaseDirBrowse.setText(RSEUIMessages.BROWSE);
        this.rseBaseDirBrowse.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseBaseDirBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteBaseDirBrowseClicked();
            }
        });
        this.rseBaseDirText = new Text((Composite)this, 2052);
        baseDirLabel.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.rseBaseDirText.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseServerHome, (int)5, null, (int)0, (Object)baseDirLabel, (int)5, (Object)this.rseBaseDirBrowse, (int)-5));
        this.rseBaseDirText.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", "standalone"));
        this.rseBaseDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.serverBaseDirChanged();
            }
        });
        Label serverConfigLabel = new Label((Composite)this, 0);
        serverConfigLabel.setText(RSEUIMessages.REMOTE_CONFIG_FILE_LABEL);
        this.rseConfigFileBrowse = new Button((Composite)this, 0);
        this.rseConfigFileBrowse.setText(RSEUIMessages.BROWSE);
        this.rseConfigFileBrowse.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseBaseDirText, (int)5, null, (int)0, null, (int)0, (Object)100, (int)-5));
        this.rseConfigFileBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteConfigBrowseClicked();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.remoteConfigBrowseClicked();
            }
        });
        this.rseConfigFileText = new Text((Composite)this, 2052);
        serverConfigLabel.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseBaseDirText, (int)7, null, (int)0, (Object)0, (int)10, null, (int)0));
        this.rseConfigFileText.setLayoutData((Object)UIUtil.createFormData2((Object)this.rseBaseDirText, (int)5, null, (int)0, (Object)serverConfigLabel, (int)5, (Object)this.rseConfigFileBrowse, (int)-5));
        this.rseConfigFileText.setText(this.callback.getServer().getAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", "standalone.xml"));
        this.rseConfigFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBoss7RSEDeploymentPrefComposite.this.configFileChanged();
            }
        });
    }

    protected void serverHomeChanged() {
        if (!this.isUpdatingFromModelChange()) {
            String safeString = this.callback.getRuntime() != null ? (this.callback.getRuntime().getLocation() != null ? this.callback.getRuntime().getLocation().toString() : "") : "";
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", this.rseServerHome.getText(), safeString, RSEUIMessages.CHANGE_REMOTE_SERVER_HOME));
        }
        this.validateWidgets();
    }

    protected String validateWidgets() {
        return this.validateWidgets(true);
    }

    protected String validateWidgets(boolean updateErrorMessage) {
        String errorMsg = null;
        if (this.serverHomeDecoration != null) {
            boolean isEmpty;
            boolean bl = isEmpty = this.rseServerHome == null || this.rseServerHome.getText() == null || this.rseServerHome.getText().trim().isEmpty();
            if (isEmpty) {
                this.serverHomeDecoration.setDescriptionText("Remote server home cannot be empty.");
                Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_DEC_FIELD_ERROR");
                this.serverHomeDecoration.setImage(image);
                this.serverHomeDecoration.show();
                errorMsg = this.serverHomeDecoration.getDescriptionText();
            } else {
                this.serverHomeDecoration.hide();
            }
        }
        if (updateErrorMessage) {
            this.callback.setErrorMessage(errorMsg);
        }
        this.callback.setComplete(errorMsg == null);
        return errorMsg;
    }

    protected void serverBaseDirChanged() {
        if (!this.isUpdatingFromModelChange()) {
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", this.rseBaseDirText.getText(), "standalone", RSEUIMessages.CHANGE_REMOTE_BASE_DIR));
        }
    }

    protected void configFileChanged() {
        if (!this.isUpdatingFromModelChange()) {
            IRuntime rt = this.callback.getRuntime();
            LocalJBoss7ServerRuntime jb7srt = rt == null ? null : (LocalJBoss7ServerRuntime)rt.loadAdapter(LocalJBoss7ServerRuntime.class, null);
            String safeString = jb7srt == null ? "" : jb7srt.getConfigurationFile();
            this.callback.execute((IUndoableOperation)new ServerModeSectionComposite.ChangeServerPropertyCommand(this.callback.getServer(), "org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", this.rseConfigFileText.getText(), safeString, RSEUIMessages.CHANGE_REMOTE_CONFIG_FILE));
        }
    }

    protected void remoteHomeBrowseClicked() {
        String home = this.rseServerHome.getText() == null ? "" : this.rseServerHome.getText();
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), home);
        if (browseVal != null) {
            this.rseServerHome.setText(browseVal);
            this.serverHomeChanged();
        }
    }

    protected void remoteBaseDirBrowseClicked() {
        String basedir = this.rseBaseDirText.getText() == null ? "" : this.rseBaseDirText.getText();
        String toOpen = null;
        toOpen = new Path(basedir).isAbsolute() ? basedir : new Path(this.rseServerHome.getText()).append(basedir).toString();
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), toOpen);
        if (browseVal != null) {
            if (browseVal.startsWith(this.rseServerHome.getText())) {
                browseVal = new Path(browseVal).makeRelativeTo((IPath)new Path(this.rseServerHome.getText())).toString();
            }
            this.rseBaseDirText.setText(browseVal);
            this.serverBaseDirChanged();
        }
    }

    protected void remoteConfigBrowseClicked() {
        Path home = new Path(this.rseServerHome.getText());
        Path basedir = new Path(this.rseBaseDirText.getText());
        Path basedir2 = basedir.isAbsolute() ? basedir : home.append((IPath)basedir);
        IPath configFolder = basedir2.append("configuration");
        IPath configFile = configFolder.append(this.rseConfigFileText.getText());
        String browseVal = RSEBrowseBehavior.browseClicked(this.rseServerHome.getShell(), this.combo.getHost(), configFile.toString());
        if (browseVal != null) {
            this.rseConfigFileText.setText(new Path(browseVal).lastSegment());
            this.configFileChanged();
        }
    }
}

