/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.jmx.integration.AbstractJBossJMXConnectionProvider;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class JBossJMXConnectionProviderModel {
    private static JBossJMXConnectionProviderModel instance;
    private HashMap<Integer, AbstractJBossJMXConnectionProvider> providers = null;

    public static JBossJMXConnectionProviderModel getDefault() {
        if (instance == null) {
            instance = new JBossJMXConnectionProviderModel();
        }
        return instance;
    }

    private void initProviders() {
        if (this.providers == null) {
            this.providers = new HashMap();
            ExtensionManager.getProviders();
        }
    }

    public void registerProvider(int type, AbstractJBossJMXConnectionProvider provider) {
        if (this.providers == null) {
            this.providers = new HashMap();
        }
        this.providers.put(type, provider);
    }

    public AbstractJBossJMXConnectionProvider getProvider(int type) {
        this.initProviders();
        return this.providers.get(type);
    }

    public IConnectionWrapper getConnection(IServer s) {
        AbstractJBossJMXConnectionProvider provider = this.getProvider(s);
        if (provider == null) {
            return null;
        }
        return provider.findConnection(s);
    }

    public AbstractJBossJMXConnectionProvider getProvider(IServer s) {
        ServerExtendedProperties properties = (ServerExtendedProperties)s.loadAdapter(ServerExtendedProperties.class, null);
        if (properties == null) {
            return null;
        }
        int i = properties.getJMXProviderType();
        this.initProviders();
        AbstractJBossJMXConnectionProvider provider = this.providers.get(i);
        return provider;
    }

    public void run(IServer s, IJMXRunnable r) throws JMXException {
        IConnectionWrapper c = this.getConnection(s);
        try {
            if (c != null) {
                c.run(r);
            }
        }
        catch (Exception e) {
            throw new JMXException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.jmx.integration", e.getMessage(), (Throwable)e));
        }
    }
}

