/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;

public class InternalRuntimeClasspathModel
implements IRuntimeClasspathModel {
    private ArrayList<IRuntimePathProvider> noFacetList = new ArrayList();
    private HashMap<String, IRuntimePathProvider[]> perFacet = new HashMap();
    private HashMap<String, HashMap<String, IRuntimePathProvider[]>> perFacetVersion = new HashMap();

    public void addProviders(IRuntimePathProvider[] providers) {
        this.noFacetList.addAll(Arrays.asList(providers));
    }

    public void setProviders(IRuntimePathProvider[] providers) {
        this.noFacetList.clear();
        this.addProviders(providers);
    }

    public void addProviders(String facet, IRuntimePathProvider[] providers) {
        this.addProviders(facet, providers, false);
    }

    public void setProviders(String facet, IRuntimePathProvider[] providers) {
        this.addProviders(facet, providers, true);
    }

    public void addProviders(String facet, IRuntimePathProvider[] providers, boolean clearFirst) {
        IRuntimePathProvider[] existing = this.perFacet.get(facet);
        ArrayList<IRuntimePathProvider> toAdd = new ArrayList<IRuntimePathProvider>();
        if (!clearFirst && existing != null) {
            toAdd.addAll(Arrays.asList(existing));
        }
        if (providers != null) {
            toAdd.addAll(Arrays.asList(providers));
        }
        this.perFacet.put(facet, toAdd.toArray(new IRuntimePathProvider[toAdd.size()]));
    }

    public void addProviders(String facet, String version, IRuntimePathProvider[] providers) {
        this.addProviders(facet, version, providers, false);
    }

    public void setProviders(String facet, String version, IRuntimePathProvider[] providers) {
        this.addProviders(facet, version, providers, true);
    }

    public void addProviders(String facet, String version, IRuntimePathProvider[] providers, boolean clearFirst) {
        HashMap<String, Object> existingFacet;
        if (facet == null) {
            this.addProviders(providers);
        }
        if (version == null) {
            this.addProviders(facet, providers);
        }
        if ((existingFacet = this.perFacetVersion.get(facet)) == null) {
            existingFacet = new HashMap();
            this.perFacetVersion.put(facet, existingFacet);
        }
        IRuntimePathProvider[] existing = existingFacet.get(facet);
        ArrayList<IRuntimePathProvider> toAdd = new ArrayList<IRuntimePathProvider>();
        if (!clearFirst && existing != null) {
            toAdd.addAll(Arrays.asList(existing));
        }
        if (providers != null) {
            toAdd.addAll(Arrays.asList(providers));
        }
        this.perFacet.put(facet, toAdd.toArray(new IRuntimePathProvider[toAdd.size()]));
    }

    @Override
    public IRuntimePathProvider[] getStandardProviders() {
        return this.noFacetList.toArray(new IRuntimePathProvider[this.noFacetList.size()]);
    }

    @Override
    public IRuntimePathProvider[] getProvidersForFacet(String id) {
        IRuntimePathProvider[] ret = this.perFacet.get(id);
        return ret == null ? this.getStandardProviders() : ret;
    }

    @Override
    public IRuntimePathProvider[] getProvidersForFacet(String id, String version) {
        if (id != null) {
            IRuntimePathProvider[] ret;
            HashMap<String, IRuntimePathProvider[]> versionToProviders = this.perFacetVersion.get(id);
            if (version != null && versionToProviders != null && (ret = versionToProviders.get(version)) != null) {
                return ret;
            }
            return this.getProvidersForFacet(id);
        }
        return this.getStandardProviders();
    }

    @Override
    public String[] getCustomizedFacets() {
        TreeSet<String> ts = new TreeSet<String>();
        ts.addAll(this.perFacet.keySet());
        return ts.toArray(new String[ts.size()]);
    }

    public String[] getCustomizedFacetVersions() {
        TreeSet<String> ts = new TreeSet<String>();
        ts.addAll(this.perFacetVersion.keySet());
        return ts.toArray(new String[ts.size()]);
    }

    public String[] getCustomizedFacetVersions(String facet) {
        HashMap<String, IRuntimePathProvider[]> k = this.perFacetVersion.get(facet);
        if (k != null) {
            TreeSet<String> ts = new TreeSet<String>();
            ts.addAll(k.keySet());
            return ts.toArray(new String[ts.size()]);
        }
        return new String[0];
    }
}

