/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleAliasUtil;
import org.jboss.ide.eclipse.as.core.server.jbossmodules.LayeredModulePathFactory;

public class ModuleSlot {
    private String module;
    private String slot;

    public ModuleSlot(String module) {
        this(module, null);
    }

    public ModuleSlot(String module, String slot) {
        this.module = module;
        this.slot = slot;
    }

    public String getModule() {
        return this.module;
    }

    public String getSlot() {
        return this.slot == null ? "main" : this.slot;
    }

    public boolean equals(Object o) {
        if (o instanceof ModuleSlot) {
            return this.isEquals(((ModuleSlot)o).getModule(), this.module) && this.isEquals(((ModuleSlot)o).getSlot(), this.slot);
        }
        return false;
    }

    private boolean isEquals(Object one, Object two) {
        if (one == null) {
            return two == null;
        }
        return two != null && one.equals(two);
    }

    public IPath getPath() {
        String slashed = this.getModule().replaceAll("\\.", "/");
        return new Path(slashed).append(this.getSlot());
    }

    public int hashCode() {
        return this.module.hashCode() + this.getSlot().hashCode();
    }

    public IPath[] getJars(IRuntime runtime) {
        IPath modulesFolder = runtime.getLocation().append("modules");
        return this.getJars(modulesFolder);
    }

    public IPath[] getJars(IPath modulesFolder) {
        File[] layeredPaths = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modulesFolder.toFile()});
        int i = 0;
        while (i < layeredPaths.length) {
            Path lay = new Path(layeredPaths[i].getAbsolutePath());
            File layeredPath = new File(lay.append(this.getPath()).toOSString());
            if (layeredPath.exists()) {
                return this.getJarsFrom(layeredPath, modulesFolder);
            }
            ++i;
        }
        return new IPath[0];
    }

    private IPath[] getJarsFrom(File layeredPath, IPath modulesFolder) {
        File modulexml;
        String alias;
        ArrayList<Path> list = new ArrayList<Path>();
        File[] children = layeredPath.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isFile() && children[i].getName().endsWith(".jar")) {
                list.add(new Path(children[i].getAbsolutePath()));
            }
            ++i;
        }
        if (list.size() == 0 && (alias = new ModuleAliasUtil().getAlias(modulexml = new File(layeredPath, "module.xml"))) != null) {
            return new ModuleSlot(alias).getJars(modulesFolder);
        }
        return list.toArray(new IPath[list.size()]);
    }
}

