/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.modules.manifest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlotCache;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;
import org.jboss.ide.eclipse.as.core.util.FileUtil;

public class ModuleSlotManifestUtil {
    public boolean isCacheOutdated(IProject p) {
        IFile[] all = this.getManifests(p);
        if (all != null) {
            return this.isCacheOutdated(all);
        }
        return true;
    }

    public void esureInCache(IFile f) {
        IFile[] all;
        ArrayList<IFile> tmp;
        IProject p = f.getProject();
        boolean initialized = ModuleSlotCache.getInstance().hasInitializedManifests(p);
        if (!initialized) {
            try {
                ModuleSlotCache.getInstance().setManifests(p, this.locateManifestFiles(p));
            }
            catch (CoreException ce) {
                ClasspathCorePlugin.getDefault().getLog().log(ce.getStatus());
            }
        }
        ArrayList<IFile> arrayList = tmp = (all = ModuleSlotCache.getInstance().getManifests(p)) == null ? new ArrayList<IFile>() : new ArrayList<IFile>(Arrays.asList(all));
        if (!tmp.contains(f)) {
            tmp.add(f);
            ModuleSlotCache.getInstance().setManifests(p, tmp.toArray(new IFile[tmp.size()]));
        }
    }

    private IFile[] getManifests(IProject p) {
        boolean initialized = ModuleSlotCache.getInstance().hasInitializedManifests(p);
        if (!initialized) {
            try {
                ModuleSlotCache.getInstance().setManifests(p, this.locateManifestFiles(p));
            }
            catch (CoreException coreException) {
                return new IFile[0];
            }
        }
        return ModuleSlotCache.getInstance().getManifests(p);
    }

    private boolean isCacheOutdated(IFile[] all) {
        int i = 0;
        while (i < all.length) {
            if (ModuleSlotCache.getInstance().isOutdated(all[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ModuleSlot[] getAllModuleSlots(IProject p) {
        ArrayList<ModuleSlot> all = new ArrayList<ModuleSlot>();
        IFile[] manifests = this.getManifests(p);
        if (manifests == null) {
            return new ModuleSlot[0];
        }
        int i = 0;
        while (i < manifests.length) {
            IFile f = manifests[i];
            if (!ModuleSlotCache.getInstance().isOutdated(f)) {
                all.addAll(Arrays.asList(ModuleSlotCache.getInstance().getEntries(f)));
            }
            ModuleSlot[] forFile = this.getSlotsForManifest(manifests[i]);
            all.addAll(Arrays.asList(forFile));
            ModuleSlotCache.getInstance().cache(f, forFile);
            ++i;
        }
        return all.toArray(new ModuleSlot[all.size()]);
    }

    private ModuleSlot[] getSlotsForManifest(IFile f) {
        ArrayList<ModuleSlot> list = new ArrayList<ModuleSlot>();
        try {
            Manifest mf;
            Attributes a;
            String val;
            String contents;
            if (f.exists() && (contents = FileUtil.getContents((IFile)f)) != null && (val = (a = (mf = new Manifest(new ByteArrayInputStream(contents.getBytes()))).getMainAttributes()).getValue("Dependencies")) != null) {
                String[] byComma = val.split(",");
                int j = 0;
                while (j < byComma.length) {
                    ModuleSlot ms = this.getModuleSlot(byComma[j]);
                    if (ms != null) {
                        list.add(ms);
                    }
                    ++j;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        return list.toArray(new ModuleSlot[list.size()]);
    }

    private ModuleSlot getModuleSlot(String ms) {
        if (ms != null) {
            if ((ms = ms.trim()).contains(" ")) {
                ms = ms.substring(0, ms.indexOf(" ")).trim();
            }
            int colon = ms.indexOf(":");
            String mod = null;
            String slot = null;
            if (colon != -1) {
                slot = ms.substring(colon + 1);
                mod = ms.substring(0, colon);
            } else {
                mod = ms;
            }
            return new ModuleSlot(mod, slot);
        }
        return null;
    }

    private IFile[] locateManifestFiles(IProject p) throws CoreException {
        final ArrayList ret = new ArrayList();
        if (p != null) {
            p.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource.getName().toLowerCase().equals("manifest.mf") && resource instanceof IFile) {
                        ret.add((IFile)resource);
                    }
                    return true;
                }
            });
        }
        return ret.toArray(new IFile[ret.size()]);
    }

    public static IRuntimePathProvider[] moduleSlotsAsProviders(ModuleSlot[] all) {
        ArrayList<LayeredProductPathProvider> ret = new ArrayList<LayeredProductPathProvider>();
        int i = 0;
        while (i < all.length) {
            ret.add(new LayeredProductPathProvider(all[i]));
            ++i;
        }
        return ret.toArray(new IRuntimePathProvider[ret.size()]);
    }
}

