/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.xpl.ModulePackager;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.tools.as.core.internal.modules.ModuleDeploymentPrefsUtil;

public class PublishUtil
extends ModuleResourceUtil {
    public static boolean DEEP = true;
    public static boolean ROOT = false;

    public static IPath getModuleNestedDeployPath(IModule[] moduleTree, String rootFolder, IDeployableServer server) {
        return new ModuleDeploymentPrefsUtil().getModuleNestedDeployPath(moduleTree, rootFolder, (IServerAttributes)server.getServer());
    }

    public static String getSuffix(String type) {
        return new ModuleDeploymentPrefsUtil().getDefaultSuffix(type);
    }

    public static boolean deployPackaged(IModule[] moduleTree) {
        String parentModuleTypeId;
        String moduleTypeId = moduleTree[moduleTree.length - 1].getModuleType().getId();
        if (moduleTypeId.equals("jst.utility")) {
            return true;
        }
        if (moduleTypeId.equals("jst.appclient")) {
            return true;
        }
        if (moduleTypeId.equals("jst.webfragment")) {
            return true;
        }
        return moduleTypeId.equals("jst.ejb") && moduleTree.length > 1 && !(parentModuleTypeId = moduleTree[moduleTree.length - 2].getModuleType().getId()).equals("jst.ear");
    }

    public static IStatus[] packModuleIntoJar(IModule module, IPath destination) throws CoreException {
        ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
        IModuleResource[] resources = pm.members();
        return PublishUtil.packModuleIntoJar(module.getName(), resources, destination);
    }

    public static IStatus[] packModuleIntoJar(String moduleName, IModuleResource[] resources, IPath destination) throws CoreException {
        return PublishUtil.packModuleIntoJar(moduleName, resources, destination, null);
    }

    public static IStatus[] packModuleIntoJar(String moduleName, IModuleResource[] resources, IPath destination, IModulePathFilter filter) throws CoreException {
        String dest = destination.toOSString();
        ModulePackager packager = null;
        try {
            try {
                packager = new ModulePackager(dest, false);
                int i = 0;
                while (i < resources.length) {
                    if (filter == null || filter.shouldInclude(resources[i])) {
                        PublishUtil.doPackModule(resources[i], packager, filter);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 1644298249, "unable to assemble module " + moduleName, (Throwable)e);
                IStatus[] iStatusArray = new IStatus[]{status};
                try {
                    if (packager != null) {
                        packager.finished();
                    }
                }
                catch (IOException e2) {
                    Status status2 = new Status(4, "org.jboss.ide.eclipse.as.core", 1644298249, "unable to assemble module " + moduleName, (Throwable)e2);
                    return new IStatus[]{status2};
                }
                return iStatusArray;
            }
        }
        catch (Throwable throwable) {
            try {
                if (packager != null) {
                    packager.finished();
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 1644298249, "unable to assemble module " + moduleName, (Throwable)e);
                return new IStatus[]{status};
            }
            throw throwable;
        }
        try {
            if (packager != null) {
                packager.finished();
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 1644298249, "unable to assemble module " + moduleName, (Throwable)e);
            return new IStatus[]{status};
        }
        return new IStatus[0];
    }

    public static void doPackModule(IModuleResource resource, ModulePackager packager) throws CoreException, IOException {
        PublishUtil.doPackModule(resource, packager, null);
    }

    public static void doPackModule(IModuleResource resource, ModulePackager packager, IModulePathFilter filter) throws CoreException, IOException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder mFolder = (IModuleFolder)resource;
            IModuleResource[] resources = mFolder.members();
            packager.writeFolder(resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            int i = 0;
            while (resources != null && i < resources.length) {
                PublishUtil.doPackModule(resources[i], packager, filter);
                ++i;
            }
        } else if (filter == null || filter.shouldInclude(resource)) {
            String destination = resource.getModuleRelativePath().append(resource.getName()).toPortableString();
            IFile file = (IFile)resource.getAdapter(IFile.class);
            if (file != null) {
                packager.write(file, destination);
            } else {
                File file2 = (File)resource.getAdapter(File.class);
                packager.write(file2, destination);
            }
        }
    }
}

