/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.resolvers;

import org.eclipse.core.internal.variables.StringSubstitutionEngine;
import org.eclipse.core.internal.variables.StringVariableManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;

public class ConfigNameResolver
implements IDynamicVariableResolver {
    public static final String JBOSS_CONFIG = "jboss_config";
    public static final String JBOSS_CONFIG_DIR = "jboss_config_dir";
    public static final String JBOSS_AS7_CONFIG_FILE = "jboss_config_file";
    public static final String JBOSS_SERVER_HOME = "jboss_server_home";
    public static final String[] ALL_VARIABLES = new String[]{"jboss_config", "jboss_config_dir", "jboss_config_file", "jboss_server_home"};

    public String performSubstitutions(String dir1, String serverOrRuntimeName) {
        return this.performSubstitutions(dir1, serverOrRuntimeName, false);
    }

    public String performSubstitutions(String dir1, String serverOrRuntimeName, boolean ignoreError) {
        String dir2;
        block3: {
            dir2 = null;
            if (dir1 != null) {
                dir2 = this.replace(dir1, JBOSS_CONFIG, serverOrRuntimeName);
                dir2 = this.replace(dir2, JBOSS_CONFIG_DIR, serverOrRuntimeName);
                dir2 = this.replace(dir2, JBOSS_AS7_CONFIG_FILE, serverOrRuntimeName);
                dir2 = this.replace(dir2, JBOSS_SERVER_HOME, serverOrRuntimeName);
                try {
                    StringSubstitutionEngine engine = new StringSubstitutionEngine();
                    dir2 = engine.performStringSubstitution(dir2, true, true, (IStringVariableManager)StringVariableManager.getDefault());
                }
                catch (CoreException ce) {
                    if (ignoreError) break block3;
                    JBossServerCorePlugin.log(ce.getStatus());
                }
            }
        }
        return dir2;
    }

    private String replace(String original, String variable, String serverOrRuntimeName) {
        if (original != null) {
            return original.replace(ConfigNameResolver.getVariablePattern(variable), ConfigNameResolver.getVariablePattern(variable, serverOrRuntimeName));
        }
        return null;
    }

    public static String getVariablePattern(String var) {
        return "${" + var + "}";
    }

    public static String getVariablePattern(String var, String serverOrRuntimeName) {
        return "${" + var + ":" + serverOrRuntimeName + "}";
    }

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        return this.resolveValue(variable.getName(), argument);
    }

    public String resolveValue(String variable, String argument) throws CoreException {
        if (variable.equals(JBOSS_CONFIG)) {
            return this.handleConfig(variable, argument);
        }
        if (variable.equals(JBOSS_CONFIG_DIR)) {
            return this.handleConfigDir(variable, argument);
        }
        if (variable.equals(JBOSS_AS7_CONFIG_FILE)) {
            return this.handleAS7ConfigFile(variable, argument);
        }
        if (variable.equals(JBOSS_SERVER_HOME)) {
            return this.handleServerHome(variable, argument);
        }
        return null;
    }

    private String handleServerHome(String variable, String argument) {
        IRuntime rt = this.findServerRuntime(argument);
        IPath loc = rt.getLocation();
        return loc == null ? null : loc.toOSString();
    }

    private String handleConfig(String variable, String argument) {
        IJBossServerRuntime ajbsrt = this.findJBossServerRuntime(argument);
        if (ajbsrt != null) {
            String config = null;
            if (ajbsrt != null) {
                config = ajbsrt.getJBossConfiguration();
            }
            if (config != null) {
                return config;
            }
        }
        return null;
    }

    private String handleConfigDir(String variable, String argument) {
        IJBossServerRuntime ajbsrt = this.findJBossServerRuntime(argument);
        if (ajbsrt != null) {
            String config = null;
            if (ajbsrt != null) {
                config = ajbsrt.getConfigLocationFullPath().append(ajbsrt.getJBossConfiguration()).toString();
            }
            if (config != null) {
                return config;
            }
        }
        return null;
    }

    private String handleAS7ConfigFile(String variable, String argument) {
        IJBossServerRuntime ajbsrt = this.findJBossServerRuntime(argument);
        if (ajbsrt != null && ajbsrt instanceof LocalJBoss7ServerRuntime) {
            return ((LocalJBoss7ServerRuntime)ajbsrt).getConfigurationFile();
        }
        return null;
    }

    private IJBossServerRuntime findJBossServerRuntime(String serverOrRuntimeName) {
        return (IJBossServerRuntime)this.findServerRuntime(serverOrRuntimeName, true);
    }

    private IRuntime findServerRuntime(String serverOrRuntimeName) {
        return (IRuntime)this.findServerRuntime(serverOrRuntimeName, false);
    }

    private Object findServerRuntime(String serverOrRuntimeName, boolean adapt) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getName().equals(serverOrRuntimeName) && servers[i].getRuntime() != null) {
                if (adapt) {
                    return (IJBossServerRuntime)servers[i].getRuntime().loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                }
                return servers[i].getRuntime();
            }
            ++i;
        }
        IRuntime[] runtimes = ServerCore.getRuntimes();
        int i2 = 0;
        while (i2 < runtimes.length) {
            if (runtimes[i2].getName().equals(serverOrRuntimeName)) {
                if (adapt) {
                    return (IJBossServerRuntime)runtimes[i2].loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
                }
                return runtimes[i2];
            }
            ++i2;
        }
        return null;
    }
}

