/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import java.net.URI;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.ExtensionManager;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.Trace;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractDeploymentScannerAdditions;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;

public class JMXServerDeploymentScannerAdditions
extends AbstractDeploymentScannerAdditions {
    @Override
    public boolean accepts(IServer server) {
        boolean jmxDeploymentScanner;
        if (!"local".equals(this.getServerMode(server))) {
            return false;
        }
        ServerExtendedProperties props = (ServerExtendedProperties)server.loadAdapter(ServerExtendedProperties.class, null);
        JBossServer jbs = (JBossServer)((Object)server.loadAdapter(JBossServer.class, (IProgressMonitor)new NullProgressMonitor()));
        boolean hasJMXProvider = jbs != null && jbs.hasJMXProvider();
        boolean bl = jmxDeploymentScanner = props != null && props.getMultipleDeployFolderSupport() == 2;
        return hasJMXProvider && jmxDeploymentScanner;
    }

    @Override
    protected void ensureScannersAdded(final IServer server, final String[] folders) {
        ExtensionManager.getDefault().getJMXRunner().beginTransaction(server, this);
        ExtensionManager.IServerJMXRunnable r = new ExtensionManager.IServerJMXRunnable(){

            @Override
            public void run(MBeanServerConnection connection) throws Exception {
                JMXServerDeploymentScannerAdditions.this.ensureDeployLocationAdded(server, connection, folders);
            }
        };
        try {
            ExtensionManager.getDefault().getJMXRunner().run(server, r);
        }
        catch (CoreException jmxe) {
            Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 33816577, Messages.AddingJMXDeploymentFailed, (Throwable)jmxe);
            ServerLogger.getDefault().log(server, (IStatus)status);
        }
    }

    private void ensureDeployLocationAdded(IServer server, MBeanServerConnection connection, String[] folders2) throws Exception {
        int i = 0;
        while (i < folders2.length) {
            String asURL = this.encode(folders2[i]);
            Trace.trace("/finer", "Adding Deployment Scanner: " + asURL);
            ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
            Object o = connection.invoke(name, "addURL", new Object[]{asURL}, new String[]{String.class.getName()});
            System.out.println(o);
            ++i;
        }
    }

    private String encode(String folder) throws Exception {
        if (!(folder = folder.replace("\\", "/")).startsWith("/")) {
            folder = "/" + folder;
        }
        URI uri = new URI("file", null, folder, null);
        return uri.toASCIIString();
    }

    @Override
    public void removeAddedDeploymentScanners(IServer server) {
    }

    @Override
    public Job getRemoveDeploymentScannerJob(IServer server) {
        return null;
    }

    protected void suspendDeployment(IServer server, MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        this.launchDeployCommand(server, connection, name, "stop", monitor);
    }

    protected void resumeDeployment(IServer server, MBeanServerConnection connection, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Resuming Deployment Scanner", 1000);
        ObjectName name = new ObjectName("jboss.deployment:flavor=URL,type=DeploymentScanner");
        this.launchDeployCommand(server, connection, name, "start", monitor);
        monitor.worked(1000);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void launchDeployCommand(IServer server, final MBeanServerConnection connection, final ObjectName objectName, final String methodName, IProgressMonitor monitor) throws Exception {
        Object object;
        final Exception[] e = new Exception[1];
        final Object waitObject = new Object();
        final Boolean[] subtaskComplete = new Boolean[]{Boolean.FALSE};
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception exception = null;
                try {
                    JMXServerDeploymentScannerAdditions.this.executeDeploymentCommand(connection, objectName, methodName);
                }
                catch (Exception ex) {
                    exception = ex;
                }
                Object object = waitObject;
                synchronized (object) {
                    e[0] = exception;
                    subtaskComplete[0] = Boolean.TRUE;
                    waitObject.notifyAll();
                }
            }
        };
        t.start();
        for (int count = 0; t.isAlive() && !monitor.isCanceled() && count <= 4000; count += 1000) {
            object = waitObject;
            synchronized (object) {
                if (subtaskComplete[0].booleanValue()) {
                    break;
                }
                waitObject.wait(1000L);
                continue;
            }
        }
        object = waitObject;
        synchronized (object) {
            if (!subtaskComplete[0].booleanValue()) {
                t.interrupt();
                Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107755008, Messages.JMXScannerCanceled, null);
                ServerLogger.getDefault().log(server, (IStatus)status);
            } else if (e[0] != null) {
                String error = methodName.equals("start") ? Messages.JMXResumeScannerError : Messages.JMXPauseScannerError;
                Status status = new Status(4, "org.jboss.ide.eclipse.as.core", 1644756992, error, (Throwable)e[0]);
                ServerLogger.getDefault().log(server, (IStatus)status);
            }
        }
    }

    protected void executeDeploymentCommand(MBeanServerConnection connection, ObjectName objectName, String methodName) throws Exception {
        connection.invoke(objectName, methodName, new Object[0], new String[0]);
    }

    public Job getSuspendScannerJob(final IServer server) {
        return new Job("Suspend Deployment Scanner"){

            protected IStatus run(final IProgressMonitor monitor) {
                ExtensionManager.getDefault().getJMXRunner().beginTransaction(server, (Object)this);
                ExtensionManager.IServerJMXRunnable r = new ExtensionManager.IServerJMXRunnable(){

                    @Override
                    public void run(MBeanServerConnection connection) throws Exception {
                        JMXServerDeploymentScannerAdditions.this.suspendDeployment(server, connection, monitor);
                    }
                };
                try {
                    ExtensionManager.getDefault().getJMXRunner().run(server, r);
                }
                catch (CoreException jmxe) {
                    Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107623936, Messages.JMXPauseScannerError, (Throwable)jmxe);
                    ServerLogger.getDefault().log(server, (IStatus)status);
                    return status;
                }
                return Status.OK_STATUS;
            }
        };
    }

    public Job getResumeScannerJob(final IServer server) {
        return new Job("Suspend Deployment Scanner"){

            protected IStatus run(final IProgressMonitor monitor) {
                ExtensionManager.IServerJMXRunnable r = new ExtensionManager.IServerJMXRunnable(){

                    @Override
                    public void run(MBeanServerConnection connection) throws Exception {
                        JMXServerDeploymentScannerAdditions.this.resumeDeployment(server, connection, monitor);
                    }
                };
                try {
                    try {
                        ExtensionManager.getDefault().getJMXRunner().run(server, r);
                    }
                    catch (CoreException jmxe) {
                        Status status = new Status(2, "org.jboss.ide.eclipse.as.core", 1107689472, Messages.JMXResumeScannerError, (Throwable)jmxe);
                        ServerLogger.getDefault().log(server, (IStatus)status);
                        Status status2 = status;
                        ExtensionManager.getDefault().getJMXRunner().endTransaction(server, (Object)this);
                        return status2;
                    }
                }
                finally {
                    ExtensionManager.getDefault().getJMXRunner().endTransaction(server, (Object)this);
                }
                return Status.OK_STATUS;
            }
        };
    }

    public void suspendScanners(IServer server) {
        Job j = this.getSuspendScannerJob(server);
        j.schedule();
        try {
            j.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void resumeScanners(IServer server) {
        Job j = this.getResumeScannerJob(server);
        j.schedule();
        try {
            j.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

