/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.catalog;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.osgi.framework.Bundle;

public class CatalogMissingEntriesTest
extends TestCase {
    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testMissingEntries() {
        String[] insidePlugin = this.findAllSchema();
        String[] insidePluginXML = this.getAllUris();
        ArrayList<String> missing = new ArrayList<String>();
        int i = 0;
        while (i < insidePlugin.length) {
            if (!this.fileInPluginXml(insidePlugin[i], insidePluginXML)) {
                missing.add(insidePlugin[i]);
            }
            ++i;
        }
        Iterator i2 = missing.iterator();
        while (i2.hasNext()) {
            System.out.println(String.valueOf((String)i2.next()) + " is not found in plugin.xml");
        }
        CatalogMissingEntriesTest.assertEquals((int)missing.size(), (int)0);
    }

    public void testMissingFile() {
        String[] insidePlugin = this.findAllSchema();
        String[] insidePluginXML = this.getAllUris();
        int i = 0;
        while (i < insidePluginXML.length) {
            if (!this.uriInPlugin(insidePluginXML[i], insidePlugin)) {
                CatalogMissingEntriesTest.fail((String)(String.valueOf(insidePlugin[i]) + " a file that is not found in the plugin"));
            }
            ++i;
        }
    }

    private boolean fileInPluginXml(String path, String[] allUri) {
        int i = 0;
        while (i < allUri.length) {
            if (allUri[i].endsWith(path)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean uriInPlugin(String uri, String[] insidePlugin) {
        int i = 0;
        while (i < insidePlugin.length) {
            if (uri.endsWith(insidePlugin[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String[] findAllSchema() {
        ArrayList<String> list = new ArrayList<String>();
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.as.catalog");
        Enumeration all = bundle.findEntries("schema", "**", true);
        URL one = null;
        while (all.hasMoreElements()) {
            one = (URL)all.nextElement();
            Path p = new Path(one.getPath());
            if (p.segmentCount() != 3 || p.lastSegment().equalsIgnoreCase(".gitignore")) continue;
            list.add(one.getPath());
        }
        return list.toArray(new String[list.size()]);
    }

    private static void fillCatalogEntryList(ICatalog c, ArrayList<String> list) {
        ICatalogEntry[] all = c.getCatalogEntries();
        int i = 0;
        while (i < all.length) {
            String uri = all[i].getURI();
            if (uri.contains("org.jboss.tools.as.catalog")) {
                list.add(all[i].getURI());
            }
            ++i;
        }
        INextCatalog[] nextCatalogs = c.getNextCatalogs();
        int i2 = 0;
        while (i2 < nextCatalogs.length) {
            CatalogMissingEntriesTest.fillCatalogEntryList(nextCatalogs[i2].getReferencedCatalog(), list);
            ++i2;
        }
    }

    private String[] getAllUris() {
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        ArrayList<String> uriList = new ArrayList<String>();
        CatalogMissingEntriesTest.fillCatalogEntryList(xmlCatalog, uriList);
        return uriList.toArray(new String[uriList.size()]);
    }

    public static IExtension[] findExtension(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }
}

