/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.classpath.modules;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.jbossmodules.LayeredModulePathFactory;
import org.jboss.tools.as.test.core.classpath.modules.MockJBossModulesUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.junit.After;

public class LayeredModulePathFactoryTest
extends TestCase {
    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    public void testOverlayAndLayerAdditions() throws IOException {
        IServer s2 = MockJBossModulesUtil.createMockServerWithRuntime("org.jboss.ide.eclipse.as.eap.61", "TestOne");
        IRuntime rt = s2.getRuntime();
        IPath modules = rt.getLocation().append("modules");
        File[] possible = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible.length == 2 ? 1 : 0) != 0);
        IPath layersRoot = modules.append("system").append("layers");
        IPath base = layersRoot.append("base");
        MockJBossModulesUtil.addOverlay(base, "overlay1");
        MockJBossModulesUtil.setActiveOverlays(base, new String[]{"overlay1"});
        File[] possible2 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible2.length == 3 ? 1 : 0) != 0);
        MockJBossModulesUtil.addOverlay(base, "overlay2");
        File[] possible3 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible3.length == 3 ? 1 : 0) != 0);
        MockJBossModulesUtil.setActiveOverlays(base, new String[]{"overlay1", "overlay2"});
        File[] possible4 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible4.length == 4 ? 1 : 0) != 0);
        IPath myLayer = MockJBossModulesUtil.addLayer(modules, "mylayer", true);
        File[] possible5 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible5.length == 5 ? 1 : 0) != 0);
        MockJBossModulesUtil.addOverlay(myLayer, "mylayerOverlay1");
        File[] possible6 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible6.length == 5 ? 1 : 0) != 0);
        MockJBossModulesUtil.setActiveOverlays(myLayer, new String[]{"mylayerOverlay1"});
        possible6 = LayeredModulePathFactory.resolveLayeredModulePath((File[])new File[]{modules.toFile()});
        LayeredModulePathFactoryTest.assertTrue((possible6.length == 6 ? 1 : 0) != 0);
    }
}

