/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server;

import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.classpath.core.runtime.RuntimeJarUtility;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.util.RuntimeUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RuntimeJarUtilityTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getJBossServerTypeParameters());
    }

    public RuntimeJarUtilityTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        try {
            this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            RuntimeJarUtilityTest.fail();
        }
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testRuntimeJarUtility() {
        RuntimeJarUtility util = new RuntimeJarUtility();
        IRuntime rt = this.server.getRuntime();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("jboss_config_dir", this.getConfigDir());
        IPath[] result1 = util.getJarsForRuntime(rt, 1);
        RuntimeJarUtilityTest.assertNotNull((Object)result1);
        RuntimeJarUtilityTest.assertTrue((result1.length > 0 ? 1 : 0) != 0);
        RuntimeJarUtilityTest.checkAllValid(result1);
        IPath[] result2 = util.getJarsForRuntimeHome(rt.getLocation().toString(), 1, replacements, false);
        RuntimeJarUtilityTest.assertNotNull((Object)result2);
        RuntimeJarUtilityTest.assertTrue((result2.length > 0 ? 1 : 0) != 0);
        RuntimeJarUtilityTest.checkAllValid(result2);
        replacements.put("jboss_config_dir", "/home/garbage/does/not/exist");
        IPath[] result3 = util.getJarsForRuntimeHome("/home/garbage/does/not/exist", 1, replacements, false);
        RuntimeJarUtilityTest.assertNull((Object)result3);
    }

    private static void checkAllValid(IPath[] paths) {
        int i = 0;
        while (i < paths.length) {
            RuntimeJarUtilityTest.assertTrue((boolean)paths[i].isAbsolute());
            RuntimeJarUtilityTest.assertTrue((boolean)paths[i].toFile().exists());
            ++i;
        }
    }

    protected String getConfigDir() {
        IJBossServerRuntime ajbsrt = this.getJBossRuntime(this.server);
        if (ajbsrt != null) {
            String config = null;
            if (ajbsrt != null) {
                config = ajbsrt.getConfigLocationFullPath().append(ajbsrt.getJBossConfiguration()).toString();
            }
            if (config != null) {
                return config;
            }
        }
        return null;
    }

    private IJBossServerRuntime getJBossRuntime(IServer s) {
        return RuntimeUtils.getJBossServerRuntime((IRuntime)s.getRuntime());
    }
}

