/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ServerProfileModel;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;
import org.jboss.tools.as.core.server.controllable.systems.AbstractJBossDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.as.test.core.subsystems.ServerSubsystemTest1;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DeploymentSettingsControllerTest
extends TestCase {
    private static final String SYSTEM = "deploymentOptions";
    private static final String LOCAL_SUBSYSTEM = "deploymentOptions.local";
    private static final String RSE_SUBSYSTEM = "deploymentOptions.rse";
    private String serverType;
    private IServer server;
    private static final String RSE_TEST_WIN_SERVER_HOME = "C:\\path\\to\\jboss\\windows";
    private static final String RSE_TEST_LINUX_SERVER_HOME = "/path/to/linux/jboss";

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(ServerParameterUtils.getAllJBossServerTypeParamterers());
    }

    public DeploymentSettingsControllerTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testResolution() throws Exception {
        ServerSubsystemTest1.ModelSubclass c = new ServerSubsystemTest1.ModelSubclass();
        String system = SYSTEM;
        SubsystemModel.SubsystemMapping[] types = c.getSubsystemMappings(this.serverType, system);
        DeploymentSettingsControllerTest.assertTrue((types != null ? 1 : 0) != 0);
        DeploymentSettingsControllerTest.assertTrue((types.length == 2 ? 1 : 0) != 0);
        boolean foundRemote = false;
        boolean foundLocal = false;
        int j = 0;
        while (j < types.length) {
            ISubsystemController controller = null;
            try {
                controller = c.createControllerForSubsystem(this.server, system, c.getSubsystemMappedId(types[j]));
            }
            catch (CoreException coreException) {
                DeploymentSettingsControllerTest.fail((String)("Error creating controller for " + system + ", " + this.serverType + ", " + c.getSubsystemMappedId(types[j])));
            }
            DeploymentSettingsControllerTest.assertNotNull((Object)controller);
            DeploymentSettingsControllerTest.assertTrue((boolean)controller.getSystemId().equals(system));
            DeploymentSettingsControllerTest.assertTrue((boolean)(controller instanceof IDeploymentOptionsController));
            if (controller.getSubsystemMappedId().equals(LOCAL_SUBSYSTEM)) {
                foundLocal = true;
            }
            if (controller.getSubsystemMappedId().equals(RSE_SUBSYSTEM)) {
                foundRemote = true;
            }
            ++j;
        }
        if (!foundLocal || !foundRemote) {
            DeploymentSettingsControllerTest.fail((String)("Must find both local and remote implementations for servertype " + this.serverType));
        }
    }

    @Test
    public void testGetAndSetZip() throws Exception {
        IDeploymentOptionsController controller = this.createController("rse", (IServerAttributes)this.server, null);
        DeploymentSettingsControllerTest.assertFalse((boolean)controller.prefersZippedDeployments());
        try {
            ((AbstractJBossDeploymentOptionsController)controller).setPrefersZippedDeployments(true);
            DeploymentSettingsControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        controller = this.createController("rse", wc);
        DeploymentSettingsControllerTest.assertFalse((boolean)controller.prefersZippedDeployments());
        ((AbstractJBossDeploymentOptionsController)controller).setPrefersZippedDeployments(true);
        DeploymentSettingsControllerTest.assertTrue((boolean)wc.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false));
        DeploymentSettingsControllerTest.assertTrue((!this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false) ? 1 : 0) != 0);
        this.server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
        DeploymentSettingsControllerTest.assertTrue((boolean)this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false));
        controller = this.createController("local", (IServerAttributes)this.server, null);
        DeploymentSettingsControllerTest.assertTrue((boolean)controller.prefersZippedDeployments());
        try {
            ((AbstractJBossDeploymentOptionsController)controller).setPrefersZippedDeployments(false);
            DeploymentSettingsControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        wc = this.server.createWorkingCopy();
        controller = this.createController("local", wc);
        DeploymentSettingsControllerTest.assertTrue((boolean)controller.prefersZippedDeployments());
        ((AbstractJBossDeploymentOptionsController)controller).setPrefersZippedDeployments(false);
        DeploymentSettingsControllerTest.assertTrue((!wc.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false) ? 1 : 0) != 0);
        DeploymentSettingsControllerTest.assertTrue((boolean)this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false));
        this.server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
        DeploymentSettingsControllerTest.assertTrue((!this.server.getAttribute("org.jboss.ide.eclipse.as.core.server.zipDeploymentsPreference", false) ? 1 : 0) != 0);
    }

    private void testLocalDeploymentServer_deployonly(String expectedDir, String expectedTmp) throws Exception {
        this.testLocalDeploymentServer_deployonly(expectedDir, expectedDir, expectedTmp, expectedTmp);
    }

    private void testLocalDeploymentServer_deployonly(String expectedDir, String expectedRelDir, String expectedTmp, String expectedRelTmp) throws Exception {
        this.testDeploymentServer_deployonly(expectedDir, expectedRelDir, expectedTmp, expectedRelTmp, "local", null);
    }

    private void testDeploymentServer_deployonly(String expectedDir, String expectedRelDir, String expectedTmp, String expectedRelTmp, String controllerFlag, boolean win) throws Exception {
        Character c = Character.valueOf(win ? (char)'\\' : '/');
        this.testDeploymentServer_deployonly(expectedDir, expectedRelDir, expectedTmp, expectedRelTmp, controllerFlag, c);
    }

    private void testDeploymentServer_deployonly(String expectedDir, String expectedRelDir, String expectedTmp, String expectedRelTmp, String controllerFlag, Character sep) throws Exception {
        IDeploymentOptionsController c = this.createController(controllerFlag, (IServerAttributes)this.server, sep);
        DeploymentSettingsControllerTest.assertEquals((String)((AbstractJBossDeploymentOptionsController)c).getCurrentDeploymentLocationType(), (String)"custom");
        try {
            ((AbstractJBossDeploymentOptionsController)c).setCurrentDeploymentLocationType("metadata");
            DeploymentSettingsControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        DeploymentSettingsControllerTest.assertEquals((String)((AbstractJBossDeploymentOptionsController)c).getCurrentDeploymentLocationType(), (String)"custom");
        String sAbsolute = c.getDeploymentsRootFolder(true);
        String sRelative = c.getDeploymentsRootFolder(false);
        DeploymentSettingsControllerTest.assertEquals((String)sAbsolute, (String)expectedDir);
        DeploymentSettingsControllerTest.assertEquals((String)sRelative, (String)expectedRelDir);
        String tAbsolute = c.getDeploymentsTemporaryFolder(true);
        String tRelative = c.getDeploymentsTemporaryFolder(false);
        DeploymentSettingsControllerTest.assertEquals((String)tAbsolute, (String)expectedTmp);
        DeploymentSettingsControllerTest.assertEquals((String)tRelative, (String)expectedRelTmp);
    }

    private void initServer(String dirType, String dir, String tmp) throws Exception {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectoryType", dirType);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", dir);
        wc.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", tmp);
        this.server = wc.save(false, null);
    }

    private IDeploymentOptionsController verifyDepType(String controllerFlag, String type, String otherType) throws Exception {
        IDeploymentOptionsController c = this.createController(controllerFlag, null);
        DeploymentSettingsControllerTest.assertEquals((String)((AbstractJBossDeploymentOptionsController)c).getCurrentDeploymentLocationType(), (String)type);
        try {
            ((AbstractJBossDeploymentOptionsController)c).setCurrentDeploymentLocationType(otherType);
            DeploymentSettingsControllerTest.fail();
        }
        catch (IllegalStateException illegalStateException) {}
        DeploymentSettingsControllerTest.assertEquals((String)((AbstractJBossDeploymentOptionsController)c).getCurrentDeploymentLocationType(), (String)type);
        return c;
    }

    @Test
    public void testLocalDeployment_Server() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.testLocalDeployment_Server_internal(depdir, depdirTmp, "server");
    }

    @Test
    public void testLocalDeployment_Server_relative() throws Exception {
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.testLocalDeployment_Server_internal(depdir, depdirTmp, "server");
    }

    public void testLocalDeployment_Server_internal(String depdir, String depdirTmp, String initialMode) throws Exception {
        this.initServer(initialMode, depdir, depdirTmp);
        if (this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            String depdir2 = new Path(depdir).makeAbsolute().toOSString();
            String depdirTmp2 = new Path(depdirTmp).makeAbsolute().toOSString();
            this.testLocalDeploymentServer_deployonly(depdir2, depdirTmp2);
            return;
        }
        IDeploymentOptionsController c = this.verifyDepType("local", initialMode, "custom");
        String sAbsolute = c.getDeploymentsRootFolder(true);
        String sRelative = c.getDeploymentsRootFolder(false);
        String tAbsolute = c.getDeploymentsTemporaryFolder(true);
        String tRelative = c.getDeploymentsTemporaryFolder(false);
        JBossExtendedProperties props = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
        int structure = props.getFileStructure();
        if (structure == 2) {
            IPath home = this.server.getRuntime().getLocation();
            IPath depTail = new Path("standalone").append("deployments");
            IPath tmpTail = new Path("standalone").append("tmp");
            DeploymentSettingsControllerTest.assertEquals((String)home.append(depTail).toOSString(), (String)sAbsolute);
            DeploymentSettingsControllerTest.assertEquals((String)depTail.toOSString(), (String)sRelative);
            DeploymentSettingsControllerTest.assertEquals((String)home.append(tmpTail).toOSString(), (String)tAbsolute);
            DeploymentSettingsControllerTest.assertEquals((String)tmpTail.toOSString(), (String)tRelative);
        } else {
            IPath home = this.server.getRuntime().getLocation();
            IPath depTail = new Path("server").append("default").append("deploy");
            IPath tmpTail = new Path("server").append("default").append("tmp").append("jbosstoolsTemp");
            DeploymentSettingsControllerTest.assertEquals((String)home.append(depTail).toOSString(), (String)sAbsolute);
            DeploymentSettingsControllerTest.assertEquals((String)depTail.toOSString(), (String)sRelative);
            DeploymentSettingsControllerTest.assertEquals((String)home.append(tmpTail).toOSString(), (String)tAbsolute);
            DeploymentSettingsControllerTest.assertEquals((String)tmpTail.toOSString(), (String)tRelative);
        }
    }

    @Test
    public void testLocalDeployment_Metadata() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.testLocalDeployment_Metadata_internal(depdir, depdirTmp, "metadata");
    }

    @Test
    public void testLocalDeployment_Metadata_relative() throws Exception {
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.testLocalDeployment_Metadata_internal(depdir, depdirTmp, "metadata");
    }

    public void testLocalDeployment_Metadata_internal(String depdir, String depdirTmp, String initialMode) throws Exception {
        this.initServer(initialMode, depdir, depdirTmp);
        if (this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            String depdir2 = new Path(depdir).makeAbsolute().toOSString();
            String depdirTmp2 = new Path(depdirTmp).makeAbsolute().toOSString();
            this.testLocalDeploymentServer_deployonly(depdir2, depdirTmp2);
            return;
        }
        IDeploymentOptionsController c = this.verifyDepType("local", initialMode, "custom");
        String sAbsolute = c.getDeploymentsRootFolder(true);
        String sRelative = c.getDeploymentsRootFolder(false);
        String tAbsolute = c.getDeploymentsTemporaryFolder(true);
        String tRelative = c.getDeploymentsTemporaryFolder(false);
        IPath stateLocation = JBossServerCorePlugin.getServerStateLocation((IServer)this.server);
        DeploymentSettingsControllerTest.assertTrue((boolean)stateLocation.isPrefixOf((IPath)new Path(sAbsolute)));
        DeploymentSettingsControllerTest.assertTrue((boolean)stateLocation.isPrefixOf((IPath)new Path(sRelative)));
        DeploymentSettingsControllerTest.assertTrue((boolean)stateLocation.isPrefixOf((IPath)new Path(tAbsolute)));
        DeploymentSettingsControllerTest.assertTrue((boolean)stateLocation.isPrefixOf((IPath)new Path(tRelative)));
    }

    @Test
    public void testLocalDeployment_Custom() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.initServer("custom", depdir, depdirTmp);
        this.testLocalDeploymentServer_deployonly(depdir, depdirTmp);
    }

    @Test
    public void testLocalDeployment_custom_relative() throws Exception {
        IPath serverHome;
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.initServer("custom", depdir, depdirTmp);
        IPath iPath = serverHome = this.server.getRuntime() == null ? null : this.server.getRuntime().getLocation();
        if (serverHome == null) {
            String depdir2 = new Path(depdir).makeAbsolute().toOSString();
            String depdirTmp2 = new Path(depdirTmp).makeAbsolute().toOSString();
            this.testLocalDeploymentServer_deployonly(depdir2, depdirTmp2);
        } else {
            this.testLocalDeploymentServer_deployonly(serverHome.append(depdir).toOSString(), depdir, serverHome.append(depdirTmp).toOSString(), depdirTmp);
        }
    }

    @Test
    public void testRemoteDeployment_Server() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.initServer("server", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "server", false);
    }

    @Test
    public void testRemoteDeployment_Server_relative() throws Exception {
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.initServer("server", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "server", false);
    }

    @Test
    public void testRemoteWindowsDeployment_Server() throws Exception {
        String depdir = "C:\\home\\user\\d\\deploy";
        String depdirTmp = "C:\\home\\user\\d\\tmp";
        this.initServer("server", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "server", true);
    }

    @Test
    public void testRemoteWindowsDeployment_Server_relative() throws Exception {
        String depdir = "d\\deploy";
        String depdirTmp = "d\\tmp";
        this.initServer("server", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "server", true);
    }

    private void initRSE(boolean windows) throws Exception {
        JBossExtendedProperties jep = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, null);
        String config = null;
        String basedir = null;
        String home = null;
        home = windows ? RSE_TEST_WIN_SERVER_HOME : RSE_TEST_LINUX_SERVER_HOME;
        if (jep != null && jep.getFileStructure() == 1) {
            config = "default2";
        } else {
            config = "standalone2.xml";
            basedir = "standalone2";
        }
        this.initRSE(home, basedir, config);
    }

    private void initRSE(String home, String basedir, String config) throws Exception {
        IServerWorkingCopy wc = this.server.createWorkingCopy();
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerBaseDir", basedir);
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerHomeDir", home);
        wc.setAttribute("org.jboss.ide.eclipse.as.rse.core.RSEServerConfig", config);
        this.server = wc.save(false, null);
    }

    public void testRemoteDeployment_Server_internal(String depdir, String depdirTmp, String initialMode, boolean windows) throws Exception {
        char sep;
        char c = sep = windows ? (char)'\\' : '/';
        if (this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            String depdir2 = new RemotePath(depdir, sep).makeAbsolute().toOSString();
            this.testDeploymentServer_deployonly(depdir2, depdir2, depdir2, depdir2, "rse", windows);
            return;
        }
        IDeploymentOptionsController c2 = this.createController("rse", null, Character.valueOf(sep));
        String sAbsolute = c2.getDeploymentsRootFolder(true);
        String sRelative = c2.getDeploymentsRootFolder(false);
        String tAbsolute = c2.getDeploymentsTemporaryFolder(true);
        String tRelative = c2.getDeploymentsTemporaryFolder(false);
        String serverHome = windows ? RSE_TEST_WIN_SERVER_HOME : RSE_TEST_LINUX_SERVER_HOME;
        JBossExtendedProperties props = (JBossExtendedProperties)this.server.loadAdapter(JBossExtendedProperties.class, (IProgressMonitor)new NullProgressMonitor());
        int structure = props.getFileStructure();
        if (structure == 2) {
            IPath tail = new RemotePath("standalone2", sep).append("deployments").makeRelative();
            String deployAbs = new RemotePath(serverHome, sep).append(tail).toOSString();
            DeploymentSettingsControllerTest.assertEquals((String)sAbsolute, (String)deployAbs);
            DeploymentSettingsControllerTest.assertEquals((String)sRelative, (String)tail.toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tAbsolute, (String)deployAbs);
            DeploymentSettingsControllerTest.assertEquals((String)tRelative, (String)tail.toOSString());
        } else {
            IPath tail = new RemotePath("server", sep).append("default2").append("deploy").makeRelative();
            String deployAbs = new RemotePath(serverHome, sep).append(tail).toOSString();
            DeploymentSettingsControllerTest.assertEquals((String)sAbsolute, (String)deployAbs);
            DeploymentSettingsControllerTest.assertEquals((String)sRelative, (String)tail.toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tAbsolute, (String)deployAbs);
            DeploymentSettingsControllerTest.assertEquals((String)tRelative, (String)tail.toOSString());
        }
    }

    @Test
    public void testRemoteDeployment_Metadata() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.initServer("metadata", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "metadata", false);
    }

    @Test
    public void testRemoteDeployment_Metadata_relative() throws Exception {
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.initServer("metadata", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "metadata", false);
    }

    @Test
    public void testRemoteWindowsDeployment_Metadata() throws Exception {
        String depdir = "C:\\home\\user\\d\\deploy";
        String depdirTmp = "C:\\home\\user\\d\\tmp";
        this.initServer("metadata", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "metadata", true);
    }

    @Test
    public void testRemoteWindowsDeployment_Metadata_relative() throws Exception {
        String depdir = "d\\deploy";
        String depdirTmp = "d\\tmp";
        this.initServer("metadata", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Server_internal(depdir, depdirTmp, "metadata", true);
    }

    @Test
    public void testRemoteDeployment_Custom() throws Exception {
        String depdir = "/home/user/d/deploy";
        String depdirTmp = "/home/user/d/tmp";
        this.initServer("custom", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Custom_internal(depdir, depdirTmp, "custom", false);
    }

    @Test
    public void testRemoteDeployment_Custom_relative() throws Exception {
        String depdir = "d/deploy";
        String depdirTmp = "d/tmp";
        this.initServer("custom", depdir, depdirTmp);
        this.initRSE(false);
        this.testRemoteDeployment_Custom_internal(depdir, depdirTmp, "custom", false);
    }

    @Test
    public void testRemoteWindowsDeployment_Custom() throws Exception {
        String depdir = "C:\\home\\user\\d\\deploy";
        String depdirTmp = "C:\\home\\user\\d\\tmp";
        this.initServer("custom", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Custom_internal(depdir, depdirTmp, "custom", true);
    }

    @Test
    public void testRemoteWindowsDeployment_Custom_relative() throws Exception {
        String depdir = "d\\deploy";
        String depdirTmp = "d\\tmp";
        this.initServer("custom", depdir, depdirTmp);
        this.initRSE(true);
        this.testRemoteDeployment_Custom_internal(depdir, depdirTmp, "custom", true);
    }

    public void testRemoteDeployment_Custom_internal(String depdir, String depdirTmp, String initialMode, boolean windows) throws Exception {
        char sep;
        char c = sep = windows ? (char)'\\' : '/';
        if (this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            String depdir2 = new RemotePath(depdir, sep).makeAbsolute().toOSString();
            this.testDeploymentServer_deployonly(depdir2, depdir2, depdir2, depdir2, "rse", windows);
            return;
        }
        IDeploymentOptionsController c2 = this.createController("rse", null, Character.valueOf(sep));
        String sAbsolute = c2.getDeploymentsRootFolder(true);
        String sRelative = c2.getDeploymentsRootFolder(false);
        String tAbsolute = c2.getDeploymentsTemporaryFolder(true);
        String tRelative = c2.getDeploymentsTemporaryFolder(false);
        boolean storedAbsolute = new RemotePath(depdir, sep).isAbsolute();
        if (storedAbsolute) {
            DeploymentSettingsControllerTest.assertEquals((String)sAbsolute, (String)new RemotePath(depdir, sep).toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)sRelative, (String)new RemotePath(depdir, sep).toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tRelative, (String)new RemotePath(depdir, sep).toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tAbsolute, (String)new RemotePath(depdir, sep).toOSString());
        } else {
            DeploymentSettingsControllerTest.assertEquals((String)sRelative, (String)new RemotePath(depdir, sep).toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tRelative, (String)new RemotePath(depdir, sep).toOSString());
            String serverHome = windows ? RSE_TEST_WIN_SERVER_HOME : RSE_TEST_LINUX_SERVER_HOME;
            DeploymentSettingsControllerTest.assertEquals((String)sAbsolute, (String)new RemotePath(new RemotePath(serverHome, sep).append(depdir).toString(), sep).toOSString());
            DeploymentSettingsControllerTest.assertEquals((String)tAbsolute, (String)new RemotePath(new RemotePath(serverHome, sep).append(depdir).toString(), sep).toOSString());
        }
    }

    private IDeploymentOptionsController createController(String targetVal, IServerWorkingCopy wc) throws Exception {
        return this.createController(targetVal, (IServerAttributes)(wc == null ? this.server : wc), null);
    }

    private IDeploymentOptionsController createController(String profileId, IServerAttributes server, Character cha) throws Exception {
        ControllerEnvironment env = new ControllerEnvironment().addProperty("PathHandling.TargetSystemSeparator", (Object)cha);
        ServerProfileModel.ServerProfile sp = ServerProfileModel.getDefault().getProfile(this.serverType, profileId);
        IServer serverToUse = server == null ? this.server : (IServer)server;
        IDeploymentOptionsController controller = (IDeploymentOptionsController)sp.getController(serverToUse, SYSTEM, env);
        return controller;
    }
}

