/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.AbstractSubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleFullRunner;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.PublishModuleIncrementalRunner;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PublishRunnerTest
extends TestCase {
    private IPath rootPath;
    private IModule m;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"C:\\some\\folder", new Character('\\')});
        ret.add(new Object[]{"/home/user/some/folder", new Character('/')});
        return ret;
    }

    public PublishRunnerTest(String basedir, Character sep) {
        this.rootPath = new RemotePath(basedir, sep.charValue());
    }

    @Test
    public void testSingleResourceRootFullPublish() throws Exception {
        TestController tc = new TestController();
        ModuleFile mf = new ModuleFile("wonka.txt", (IPath)new Path("/"), System.currentTimeMillis());
        IModuleResource[] asArr = new IModuleResource[]{mf};
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        PublishRunnerTest.assertTrue((boolean)tc.mkdir.contains(this.rootPath));
        PublishRunnerTest.assertTrue((boolean)tc.copied.contains(this.rootPath.append("wonka.txt")));
    }

    @Test
    public void testSingleResourceDeepFullPublish() throws Exception {
        TestController tc = new TestController();
        ModuleFile mf = new ModuleFile("wonka.txt", (IPath)new Path("some/inner/path"), System.currentTimeMillis());
        IModuleResource[] asArr = new IModuleResource[]{mf};
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, (IPath)new Path("some/inner/path/wonka.txt"));
    }

    @Test
    public void testSingleMultipleDeepFullPublish() throws Exception {
        TestController tc = new TestController();
        ModuleFile mf = new ModuleFile("wonka.txt", (IPath)new Path("some/inner/path"), System.currentTimeMillis());
        ModuleFile mf2 = new ModuleFile("wonka2.pdf", (IPath)new Path("some/weird/path"), System.currentTimeMillis());
        IModuleResource[] asArr = new IModuleResource[]{mf, mf2};
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, (IPath)new Path("some/inner/path/wonka.txt"));
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, (IPath)new Path("some/weird/path/wonka2.pdf"));
    }

    @Test
    public void testDeepFolderWithNestedFileFullPublish() throws Exception {
        TestController tc = new TestController();
        ModuleFolder mf = new ModuleFolder(null, "finalDeepFolder", (IPath)new Path("some/inner/path"));
        ModuleFile mf2 = new ModuleFile("wonka2.pdf", (IPath)new Path("some/inner/path/finalDeepFolder"), System.currentTimeMillis());
        mf.setMembers(new IModuleResource[]{mf2});
        IModuleResource[] asArr = new IModuleResource[]{mf};
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        this.assertFolderAndParentDirsMade(tc, this.rootPath, (IPath)new Path("some/inner/path/finalDeepFolder"));
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, (IPath)new Path("some/inner/path/finalDeepFolder/wonka2.pdf"));
    }

    @Test
    public void testStandardModuleFullPublish() throws Exception {
        TestController tc = new TestController();
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] asArr = md.members();
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, this.getLeafs1());
    }

    @Test
    public void testStandardModuleFullPublishWithCancel() throws Exception {
        TestController tc = new TestController();
        tc.cancelAfterFirstAction = true;
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] asArr = md.members();
        PublishModuleFullRunner runner = new PublishModuleFullRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.fullPublish(asArr, null);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        PublishRunnerTest.assertEquals((int)tc.numCalls(), (int)1);
    }

    @Test
    public void testStandardModuleIncrementalPublishNoChange() throws Exception {
        TestController tc = new TestController();
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] asArr = md.members();
        IPath[] leafs = this.getLeafs1();
        int[] kind = new int[leafs.length];
        int i = 0;
        while (i < leafs.length) {
            kind[i] = 0;
            ++i;
        }
        IModuleResourceDelta[] mockDelta = MockModuleUtil.createMockResourceDeltas(Arrays.asList(asArr), leafs, kind);
        PublishModuleIncrementalRunner runner = new PublishModuleIncrementalRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.publish(mockDelta, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        PublishRunnerTest.assertTrue((tc.copied.size() == 0 ? 1 : 0) != 0);
        PublishRunnerTest.assertTrue((tc.mkdir.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testStandardModuleIncrementalPublishAllChanged() throws Exception {
        TestController tc = new TestController();
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] asArr = md.members();
        IPath[] leafs = this.getLeafs1();
        int[] kind = new int[leafs.length];
        int i = 0;
        while (i < leafs.length) {
            kind[i] = 2;
            ++i;
        }
        IModuleResourceDelta[] mockDelta = MockModuleUtil.createMockResourceDeltas(Arrays.asList(asArr), leafs, kind);
        PublishModuleIncrementalRunner runner = new PublishModuleIncrementalRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.publish(mockDelta, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        this.assertFileCopiedAndParentDirsMade(tc, this.rootPath, this.getLeafs1());
    }

    @Test
    public void testIncrementalPublishWithCancel() throws Exception {
        TestController tc = new TestController();
        tc.cancelAfterFirstAction = true;
        IModule m = this.createTestMockModule();
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        IModuleResource[] asArr = md.members();
        IPath[] leafs = this.getLeafs1();
        int[] kind = new int[leafs.length];
        int i = 0;
        while (i < leafs.length) {
            kind[i] = 2;
            ++i;
        }
        IModuleResourceDelta[] mockDelta = MockModuleUtil.createMockResourceDeltas(Arrays.asList(asArr), leafs, kind);
        PublishModuleIncrementalRunner runner = new PublishModuleIncrementalRunner((IFilesystemController)tc, this.rootPath);
        try {
            runner.publish(mockDelta, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
        PublishRunnerTest.assertEquals((int)tc.numCalls(), (int)1);
    }

    private void assertFileCopiedAndParentDirsMade(TestController controller, IPath root, IPath[] relative) {
        int i = 0;
        while (i < relative.length) {
            this.assertFileCopiedAndParentDirsMade(controller, root, relative[i]);
            ++i;
        }
    }

    private void assertFileCopiedAndParentDirsMade(TestController controller, IPath root, IPath relative) {
        this.assertParentDirsMade(controller, root, relative);
        PublishRunnerTest.assertTrue((boolean)controller.copied.contains(root.append(relative)));
    }

    private void assertFolderAndParentDirsMade(TestController controller, IPath root, IPath relative) {
        this.assertParentDirsMade(controller, root, relative);
        PublishRunnerTest.assertTrue((boolean)controller.mkdir.contains(root.append(relative)));
    }

    private void assertParentDirsMade(TestController controller, IPath root, IPath relative) {
        IPath working = root;
        PublishRunnerTest.assertTrue((boolean)controller.mkdir.contains(working));
        int i = 0;
        while (i < relative.segmentCount() - 1) {
            working = working.append(relative.segment(i));
            if (!controller.mkdir.contains(working)) {
                System.out.println("Test failing");
            }
            PublishRunnerTest.assertTrue((boolean)controller.mkdir.contains(working));
            ++i;
        }
    }

    private IPath[] getLeafs1() {
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2"), new Path("c/y3"), new Path("c/y4"), new Path("d/F/f1"), new Path("d/F/f2"), new Path("d/F/f3"), new Path("d/F/f4")};
        return leafs;
    }

    private IModule createTestMockModule() {
        MockModule m = MockModuleUtil.createMockWebModule();
        IModuleResource[] all = MockModuleUtil.createMockResources(this.getLeafs1(), new IPath[0]);
        m.setMembers(all);
        return m;
    }

    private static class TestController
    extends AbstractSubsystemController
    implements IFilesystemController {
        private ArrayList<IPath> copied = new ArrayList();
        private ArrayList<IPath> deleted = new ArrayList();
        private ArrayList<IPath> checkedIsFile = new ArrayList();
        private ArrayList<IPath> mkdir = new ArrayList();
        private ArrayList<IPath> touch = new ArrayList();
        private boolean canceled = false;
        private boolean cancelAfterFirstAction = false;
        private int callCount = 0;

        private TestController() {
        }

        private int sumAllArrays() {
            return this.copied.size() + this.deleted.size() + this.checkedIsFile.size() + this.mkdir.size() + this.touch.size();
        }

        private int numCalls() {
            return this.callCount;
        }

        private void checkCancel(IProgressMonitor monitor) throws CoreException {
            ++this.callCount;
            if (this.canceled) {
                throw new CoreException((IStatus)new Status(4, null, "Monitor is already canceled. This should not be called"));
            }
            if (this.cancelAfterFirstAction) {
                monitor.setCanceled(true);
                this.canceled = true;
            }
        }

        public IStatus copyFile(File f, IPath path, IProgressMonitor monitor) throws CoreException {
            this.checkCancel(monitor);
            this.copied.add(path);
            return null;
        }

        public IStatus deleteResource(IPath path, IProgressMonitor monitor) throws CoreException {
            this.checkCancel(monitor);
            this.deleted.add(path);
            return null;
        }

        public boolean isFile(IPath path, IProgressMonitor monitor) throws CoreException {
            this.checkCancel(monitor);
            this.checkedIsFile.add(path);
            return false;
        }

        public IStatus makeDirectoryIfRequired(IPath dir, IProgressMonitor monitor) throws CoreException {
            this.checkCancel(monitor);
            IPath working = dir;
            while (working.segmentCount() > 0) {
                if (!this.mkdir.contains(working)) {
                    this.mkdir.add(working);
                }
                working = working.removeLastSegments(1);
            }
            return null;
        }

        public IStatus touchResource(IPath path, IProgressMonitor monitor) throws CoreException {
            this.checkCancel(monitor);
            this.touch.add(path);
            return null;
        }

        public boolean exists(IPath path, IProgressMonitor monitor) throws CoreException {
            return false;
        }
    }
}

