/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.utiltests;

import java.util.ArrayList;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;

public class RSEUtilsTest
extends TestCase {
    public static final String HOST_NAME = "127.0.0.1";
    private IHost host;

    protected void tearDown() throws Exception {
        ASMatrixTests.cleanup();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        sr.deleteHost(this.host);
    }

    public void testRemoteUnix() {
        this.host = this.createLinuxHost(HOST_NAME);
        RSEUtilsTest.assertNotNull((Object)this.host);
        String home = "/home/wonkauser/jboss-eap-5.1";
        IServer s = this.createEAP5Server(home);
        String args = this.getStartArgsForServer(s);
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/lib/endorsed"));
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/server"));
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/bin/native"));
    }

    public void testRemoteSshOnly() {
        this.host = this.createSshOnlyHost(HOST_NAME);
        RSEUtilsTest.assertNotNull((Object)this.host);
        String home = "/home/wonkauser/jboss-eap-5.1";
        IServer s = this.createEAP5Server(home);
        String args = this.getStartArgsForServer(s);
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/lib/endorsed"));
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/server"));
        RSEUtilsTest.assertTrue((boolean)args.contains("/home/wonkauser/jboss-eap-5.1/bin/native"));
    }

    public void testRemoteWindows() {
        this.host = this.createWindowsHost(HOST_NAME);
        RSEUtilsTest.assertNotNull((Object)this.host);
        String home = "c:\\apps\\jboss\\jboss-eap-5.1";
        IServer s = this.createEAP5Server(home);
        String args = this.getStartArgsForServer(s);
        RSEUtilsTest.assertTrue((boolean)args.contains("c:\\apps\\jboss\\jboss-eap-5.1\\lib\\endorsed"));
        RSEUtilsTest.assertTrue((boolean)args.contains("c:\\apps\\jboss\\jboss-eap-5.1\\server"));
        RSEUtilsTest.assertTrue((boolean)args.contains("c:\\apps\\jboss\\jboss-eap-5.1\\bin\\native"));
        RSEUtilsTest.assertFalse((boolean)args.contains("=null"));
    }

    public IServer createEAP5Server(String homeDir) {
        IServer s = null;
        try {
            s = this.createRemoteServer("org.jboss.ide.eclipse.as.runtime.eap.50", this.host, homeDir, "default");
        }
        catch (CoreException ce) {
            RSEUtilsTest.fail((String)("Server not created: " + ce.getMessage()));
        }
        if (s == null) {
            RSEUtilsTest.fail((String)"Server not created.");
        }
        return s;
    }

    public String getStartArgsForServer(IServer s) {
        try {
            ILaunchConfiguration lc = s.getLaunchConfiguration(true, (IProgressMonitor)new NullProgressMonitor());
            String currentStartupCmd = new RSELaunchConfigProperties().getStartupCommand(lc);
            return currentStartupCmd;
        }
        catch (CoreException e) {
            RSEUtilsTest.fail((String)e.getMessage());
            return null;
        }
    }

    public IServer createRemoteServer(String serverType, IHost host, String remoteHome, String remoteConfig) throws CoreException {
        IServer s = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.eap.50", "server1");
        return RSEUtils.setServerToRSEMode((IServer)s, (IHost)host, (String)remoteHome, (String)remoteConfig);
    }

    public IHost createSshOnlyHost(String hostname) throws AssertionFailedError {
        String[] configurations = new String[]{"ssh.files", "ssh.shells", "ssh.terminals"};
        return this.createHost(hostname, "org.eclipse.rse.systemtype.ssh", configurations);
    }

    public IHost createLinuxHost(String hostName) throws AssertionFailedError {
        String[] configurations = new String[]{"ssh.files", "processes.shell.linux", "ssh.shells", "ssh.terminals"};
        return this.createHost(hostName, "org.eclipse.rse.systemtype.linux", configurations);
    }

    public IHost createWindowsHost(String hostName) throws AssertionFailedError {
        String[] configurations = new String[]{"dstore.windows.files", "dstore.shells"};
        return this.createHost(hostName, "org.eclipse.rse.systemtype.windows", configurations);
    }

    public IHost createHost(String hostName, String sysType, String[] configurationIds) throws AssertionFailedError {
        String profileName = this.getOrCreateSystemProfileName();
        IRSESystemType systemType = this.findSystemType(sysType);
        RSEUtilsTest.assertNotNull((Object)("System type not found: " + sysType));
        ArrayList<ISubSystemConfigurator> configuratorList = new ArrayList<ISubSystemConfigurator>();
        int i = 0;
        while (i < configurationIds.length) {
            configuratorList.add(this.createSubsystemConfigurator(configurationIds[i]));
            ++i;
        }
        ISubSystemConfigurator[] configurators = configuratorList.toArray(new ISubSystemConfigurator[configuratorList.size()]);
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        try {
            IHost host = sr.createHost(profileName, systemType, hostName, hostName, "test host", "", 0, configurators);
            return host;
        }
        catch (Exception e) {
            RSEUtilsTest.fail((String)("Failed to create host: " + e.getMessage()));
            return null;
        }
    }

    private ISubSystemConfigurator createSubsystemConfigurator(String id) {
        return new DefaultConfigurator(this.findSubsystemConfiguration(id));
    }

    private ISubSystemConfiguration findSubsystemConfiguration(String id) {
        return RSECorePlugin.getTheSystemRegistry().getSubSystemConfiguration(id);
    }

    private String getOrCreateSystemProfileName() {
        String[] profiles = RSECorePlugin.getTheSystemProfileManager().getActiveSystemProfileNames();
        int i = 0;
        while (i < profiles.length) {
            if (profiles[i] != null) {
                return profiles[i];
            }
            ++i;
        }
        ISystemProfile p = RSECorePlugin.getTheSystemProfileManager().createSystemProfile("test", true);
        return p.getName();
    }

    private IRSESystemType findSystemType(String id) {
        IRSESystemType[] systemTypes = RSECorePlugin.getTheCoreRegistry().getSystemTypes();
        int i = 0;
        while (i < systemTypes.length) {
            if (systemTypes[i].getId().equals(id)) {
                return systemTypes[i];
            }
            ++i;
        }
        return null;
    }

    private class DefaultConfigurator
    implements ISubSystemConfigurator {
        private ISubSystemConfiguration _configuration;

        public DefaultConfigurator(ISubSystemConfiguration configuration) {
            this._configuration = configuration;
        }

        public boolean applyValues(ISubSystem ss) {
            return true;
        }

        public ISubSystemConfiguration getSubSystemConfiguration() {
            return this._configuration;
        }
    }
}

