/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.events;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLog;
import org.jboss.ide.eclipse.as.core.server.IServerLogListener;
import org.osgi.service.prefs.BackingStoreException;

public class ServerLogger {
    private static final String RELOG_ERROR_PREF_KEY = "package org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger.RELOG_ERROR_PREF_KEY";
    private static ServerLogger instance;
    private HashMap<String, ServerLog> map = new HashMap();
    private HashMap<String, ArrayList<IServerLogListener>> listeners = new HashMap();

    public static ServerLogger getDefault() {
        if (instance == null) {
            instance = new ServerLogger();
        }
        return instance;
    }

    public void addListener(IServer server, IServerLogListener listener) {
        ArrayList<Object> list = this.listeners.get(server.getId());
        if (list == null) {
            list = new ArrayList();
            this.listeners.put(server.getId(), list);
        }
        list.add(listener);
    }

    public void removeListener(IServer server, IServerLogListener listener) {
        ArrayList<IServerLogListener> list = this.listeners.get(server.getId());
        if (list != null) {
            list.remove(listener);
        }
    }

    public void log(IServer server, IStatus status) {
        ArrayList<IServerLogListener> list;
        ServerLog log = this.map.get(server.getId());
        if (log == null) {
            log = new ServerLog(ServerLogger.getServerLogFile(server));
            this.map.put(server.getId(), log);
        }
        log.log(status);
        if (ServerLogger.shouldDoubleLogErrors() && status.getSeverity() == 4) {
            JBossServerCorePlugin.getDefault().getLog().log(status);
        }
        if ((list = this.listeners.get(server.getId())) != null) {
            IServerLogListener[] listeners = list.toArray(new IServerLogListener[list.size()]);
            int i = 0;
            while (i < listeners.length) {
                listeners[i].logging(status, server);
                ++i;
            }
        }
    }

    public IStatus[] getLog(IServer server) {
        ServerLog log = this.map.get(server.getId());
        if (log == null) {
            return new IStatus[0];
        }
        return log.getLogStatusObjects();
    }

    public static boolean shouldDoubleLogErrors() {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.as.core");
        return prefs.getBoolean(RELOG_ERROR_PREF_KEY, true);
    }

    public static void setDoubleLogErrors(boolean val) {
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.as.core");
        prefs.putBoolean(RELOG_ERROR_PREF_KEY, val);
        try {
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            JBossServerCorePlugin.log((IStatus)new Status(2, "org.jboss.ide.eclipse.as.core", bse.getMessage(), (Throwable)bse));
        }
    }

    public static File getServerLogFile(IServer server) {
        File f = JBossServerCorePlugin.getServerStateLocation(server).append("log").toFile();
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f;
    }

    public static IServer findServerForFile(File file) {
        if (file == null) {
            return null;
        }
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (ServerLogger.getServerLogFile(servers[i]).equals(file)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }
}

