/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jvmmonitor.internal.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.jboss.tools.jmx.jvmmonitor.core.IHeapDumpHandler;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Messages;
import org.jboss.tools.jmx.jvmmonitor.internal.tools.Tools;

public class HeapDumpHandler
implements IHeapDumpHandler {
    private static final int BUFFER_SIZE = 2048;

    public String dumpHeap(int pid, boolean isLive) throws JvmCoreException {
        String string;
        block7: {
            Tools tools = Tools.getInstance();
            Object virtualMachine = null;
            try {
                virtualMachine = tools.invokeAttach(pid);
                string = HeapDumpHandler.getHeapHistogram(virtualMachine, isLive);
                if (virtualMachine == null) break block7;
            }
            catch (Throwable throwable) {
                if (virtualMachine != null) {
                    try {
                        tools.invokeDetach(virtualMachine);
                    }
                    catch (JvmCoreException jvmCoreException) {}
                }
                throw throwable;
            }
            try {
                tools.invokeDetach(virtualMachine);
            }
            catch (JvmCoreException jvmCoreException) {}
        }
        return string;
    }

    public int getMaxClassesNumber() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.tools.jmx.jvmmonitor.tools");
        return prefs.getInt("org.jboss.tools.jmx.jvmmonitor.tools.class.maxNumber", 3000);
    }

    private static String getHeapHistogram(Object virtualMachine, boolean isLive) throws JvmCoreException {
        InputStream in = Tools.getInstance().invokeHeapHisto(virtualMachine, isLive);
        byte[] bytes = new byte[2048];
        StringBuilder builder = new StringBuilder();
        try {
            try {
                int length;
                while ((length = in.read(bytes)) != -1) {
                    String string = new String(bytes, 0, length, "UTF8");
                    builder.append(string);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new JvmCoreException(4, Messages.charsetNotSupportedMsg, (Throwable)e);
            }
            catch (IOException e) {
                throw new JvmCoreException(4, Messages.readInputStreamFailedMsg, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return builder.toString();
    }
}

