/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.Collections;
import java.util.List;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ErrorNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IErrorNode;

public abstract class ContainerNode<T extends IContainerNode<?>>
extends ContentNode<T>
implements IContainerNode<T> {
    private IErrorNode error;

    protected ContainerNode(IServer server, String name) {
        super(server, name);
    }

    protected ContainerNode(T container, String name) {
        super(container, name);
    }

    @Override
    public final List<? extends IContentNode<?>> getChildren() {
        if (this.error != null) {
            return Collections.singletonList(this.error);
        }
        return this.delegateGetChildren();
    }

    @Override
    public final void clearChildren() {
        this.clearError();
        this.delegateClearChildren();
    }

    protected void setError(IErrorNode error) {
        this.clearError();
        this.error = error;
    }

    @Override
    public void dispose() {
        this.clearChildren();
        super.dispose();
    }

    @Override
    public final void load() {
        if (this.getServer().getServerState() != 2) {
            this.setError(new ErrorNode(this, Messages.ServerContent_Label_Not_Connected));
            return;
        }
        try {
            this.delegateLoad();
            this.clearError();
        }
        catch (Exception exception) {
            this.setError(new ErrorNode(this, Messages.ServerContent_Label_Retrieval_Error));
        }
    }

    protected abstract List<? extends IContentNode<?>> delegateGetChildren();

    protected abstract void delegateClearChildren();

    protected abstract void delegateLoad() throws Exception;

    private void clearError() {
        if (this.error != null) {
            this.error.dispose();
            this.error = null;
        }
    }
}

