/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.as7.management.content;

import java.util.LinkedList;
import org.eclipse.wst.server.core.IServer;
import org.jboss.dmr.ModelNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContainerNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IContentNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.IResourceNode;
import org.jboss.ide.eclipse.as.ui.views.as7.management.content.ITypeNode;

public class ContentNode<T extends IContainerNode<?>>
implements IContentNode<T> {
    public static final String PATH_SEPARATOR = "/";
    private final IServer server;
    private IResourceNode parent;
    private T container;
    private final String name;

    protected ContentNode(IServer server, String name) {
        this.server = server;
        this.parent = null;
        this.container = null;
        this.name = name;
    }

    protected ContentNode(T container, String name) {
        this.server = container.getServer();
        this.parent = container instanceof IResourceNode ? (IResourceNode)container : container.getParent();
        this.container = container;
        this.name = name;
    }

    @Override
    public IResourceNode getParent() {
        return this.parent;
    }

    @Override
    public T getContainer() {
        return this.container;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAddress() {
        return String.valueOf(this.getParent().getAddress()) + PATH_SEPARATOR + this.getName();
    }

    @Override
    public IServer getServer() {
        return this.server;
    }

    @Override
    public void dispose() {
        this.container = null;
        this.parent = null;
    }

    protected static ModelNode getManagementAddress(IResourceNode resource) {
        ModelNode address = new ModelNode();
        LinkedList<IResourceNode> resources = new LinkedList<IResourceNode>();
        resources.push(resource);
        IResourceNode parent = resource.getParent();
        while (parent != null) {
            resources.push(parent);
            parent = parent.getParent();
        }
        do {
            ITypeNode type;
            if ((type = (ITypeNode)(resource = (IResourceNode)resources.pop()).getContainer()) == null) continue;
            address.add(type.getName(), resource.getName());
        } while (!resources.isEmpty());
        return address;
    }
}

