/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.internal.viewers.InitialSelectionProvider;
import org.osgi.service.prefs.BackingStoreException;

public class JBInitialSelectionProvider
extends InitialSelectionProvider
implements IServerLifecycleListener,
IRuntimeLifecycleListener {
    private static String LAST_SERVER_CREATED_KEY = "org.jboss.ide.eclipse.as.ui.wizards.LAST_SERVER_CREATED";
    private static String LAST_RUNTIME_CREATED_KEY = "org.jboss.ide.eclipse.as.ui.wizards.LAST_RUNTIME_CREATED";
    private static String DEFAULT_INITIAL_SERVER_TYPE = "DEFAULT_SERVER_TYPE";
    private static String DEFAULT_INITIAL_RUNTIME_TYPE = "DEFAULT_RUNTIME_TYPE";
    private static final String LATEST_JBT_SERVER = "org.jboss.ide.eclipse.as.wildfly.80";
    private static final String LATEST_JBT_RUNTIME = "org.jboss.ide.eclipse.as.runtime.wildfly.80";

    public IServerType getDefaultServerType() {
        IEclipsePreferences defaults = DefaultScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
        String newestJBoss = defaults.get(DEFAULT_INITIAL_SERVER_TYPE, LATEST_JBT_SERVER);
        return ServerCore.findServerType((String)newestJBoss);
    }

    public IRuntimeType getDefaultRuntimeType() {
        IEclipsePreferences defaults = DefaultScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
        String newestJBoss = defaults.get(DEFAULT_INITIAL_RUNTIME_TYPE, LATEST_JBT_RUNTIME);
        return ServerCore.findRuntimeType((String)newestJBoss);
    }

    public IRuntimeType getInitialSelection(IRuntimeType[] runtimeTypes) {
        return (IRuntimeType)this.getInitialSelection(runtimeTypes, LAST_RUNTIME_CREATED_KEY, true, this.getDefaultRuntimeType());
    }

    public IServerType getInitialSelection(IServerType[] serverTypes) {
        return (IServerType)this.getInitialSelection(serverTypes, LAST_SERVER_CREATED_KEY, true, this.getDefaultServerType());
    }

    private Object getInitialSelection(Object[] types, String lastKey, boolean isServer, Object defaultType) {
        ArrayList<Object> typesList = new ArrayList<Object>();
        typesList.addAll(Arrays.asList(types));
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
        String last = prefs.get(lastKey, null);
        IServerType lastObject = null;
        if (isServer) {
            IServer lastServer = last == null ? null : ServerCore.findServer((String)last);
            lastObject = lastServer == null ? null : lastServer.getServerType();
        } else {
            IRuntime lastRuntime = last == null ? null : ServerCore.findRuntime((String)last);
            IRuntimeType iRuntimeType = lastObject = lastRuntime == null ? null : lastRuntime.getRuntimeType();
        }
        if (lastObject != null && typesList.contains(lastObject)) {
            return lastObject;
        }
        if (typesList.contains(defaultType)) {
            return defaultType;
        }
        return types == null || types.length == 0 ? null : types[0];
    }

    private void store(String id, String key) {
        if (id != null) {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.jboss.ide.eclipse.as.ui");
            prefs.put(key, id);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void serverAdded(IServer server) {
        this.store(server == null ? null : server.getId(), LAST_SERVER_CREATED_KEY);
    }

    public void runtimeAdded(IRuntime runtime) {
        this.store(runtime == null ? null : runtime.getId(), LAST_RUNTIME_CREATED_KEY);
    }

    public void serverChanged(IServer server) {
    }

    public void serverRemoved(IServer server) {
    }

    public void runtimeChanged(IRuntime runtime) {
    }

    public void runtimeRemoved(IRuntime runtime) {
    }
}

