/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.PathProviderResolutionUtil;
import org.jboss.ide.eclipse.as.classpath.core.runtime.internal.SourceJarsLocator;
import org.jboss.ide.eclipse.as.core.resolvers.ConfigNameResolver;
import org.jboss.ide.eclipse.as.core.server.bean.ServerBeanLoader;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;

public class RuntimeJarUtility {
    public static final int CLASSPATH_JARS = 1;
    public static final int ALL_JARS = 2;
    public static final String CONFIG_DIR_VAR_PATTERN = ConfigNameResolver.getVariablePattern((String)"jboss_config_dir");
    public static final String SERVER_HOME_VAR_PATTERN = ConfigNameResolver.getVariablePattern((String)"jboss_server_home");

    public IPath[] getJarsForRuntime(IRuntime rt, int type) {
        if (type == 1) {
            IRuntimePathProvider[] sets = CustomRuntimeClasspathModel.getInstance().getEntries(rt.getRuntimeType());
            IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(rt, sets);
            return allPaths;
        }
        if (type == 2) {
            IRuntimePathProvider[] sets = new SourceJarsLocator().getDefaultPathProviders(rt.getRuntimeType());
            IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(rt, sets);
            return allPaths;
        }
        return null;
    }

    public IPath[] getJarsForRuntimeHome(String home, int type) {
        return this.getJarsForRuntimeHome(home, type, true);
    }

    public IPath[] getJarsForRuntimeHome(String home, int type, boolean setDefaults) {
        HashMap<String, String> map = new HashMap<String, String>();
        return this.getJarsForRuntimeHome(home, type, map, setDefaults);
    }

    public IPath[] getJarsForRuntimeHome(String home, int type, Map<String, String> replacements, boolean setDefaultReplacements) {
        IRuntimeType rtType;
        replacements.put("jboss_server_home", home);
        ServerBeanLoader loader = new ServerBeanLoader(new File(home));
        String serverType = loader.getServerAdapterId();
        IServerType t = serverType == null ? null : ServerCore.findServerType((String)serverType);
        IRuntimeType iRuntimeType = rtType = t == null ? null : t.getRuntimeType();
        if (rtType == null) {
            return null;
        }
        if (setDefaultReplacements) {
            this.setDefaultReplacements(t, home, replacements);
        }
        if (type == 1) {
            IRuntimePathProvider[] sets = CustomRuntimeClasspathModel.getInstance().getEntries(rtType);
            IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(replacements, sets);
            return allPaths;
        }
        if (type == 2) {
            IRuntimePathProvider[] sets = new SourceJarsLocator().getDefaultPathProviders(rtType);
            IPath[] allPaths = PathProviderResolutionUtil.getAllPaths(replacements, sets);
            return allPaths;
        }
        return null;
    }

    private void setDefaultReplacements(IServerType type, String home, Map<String, String> replacements) {
        ServerExtendedProperties props = (ServerExtendedProperties)Platform.getAdapterManager().getAdapter((Object)type, ServerExtendedProperties.class);
        if (props != null) {
            int fileStructure = props.getFileStructure();
            Path serverHome = new Path(home);
            if (fileStructure == 1) {
                if (replacements.get("jboss_config") == null) {
                    replacements.put("jboss_config", "default");
                }
                String cfg = replacements.get("jboss_config");
                if (replacements.get("jboss_config_dir") == null) {
                    replacements.put("jboss_config_dir", serverHome.append("server").append(cfg).toOSString());
                }
            }
            if (fileStructure == 1) {
                if (replacements.get("jboss_config_file") == null) {
                    replacements.put("jboss_config_file", "standalone.xml");
                }
                if (replacements.get("jboss_config_dir") == null) {
                    replacements.put("jboss_config_dir", serverHome.append("standalone").append("configuration").toOSString());
                }
            }
        }
    }
}

