/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.rse.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.ServerUtil;
import org.jboss.ide.eclipse.as.core.util.JBossServerBehaviorUtils;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.rse.core.RSELaunchConfigProperties;
import org.jboss.ide.eclipse.as.rse.core.RSEUtils;
import org.jboss.ide.eclipse.as.rse.core.StandardRSEStartLaunchDelegate;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public class StandardRSEJBossStartLaunchDelegate
extends StandardRSEStartLaunchDelegate {
    protected static final String DELIMETER = ":";
    protected static final String ECHO_KEY_DISCOVER_PID = "JBTOOLS_SERVER_START_CMD";

    @Override
    protected void beforeVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        String serverHome = RSEUtils.getRSEHomeDir((IServerAttributes)beh.getServer());
        RemotePath remoteHome = new RemotePath(serverHome, RSEUtils.getRemoteSystemSeparatorCharacter((IServerAttributes)beh.getServer()));
        IFilesystemController fs = (IFilesystemController)beh.getController("filesystem");
        if (!fs.exists((IPath)remoteHome, monitor)) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "The remote server's home directory does not exist: " + serverHome));
        }
        super.beforeVMRunner(configuration, mode, launch, monitor);
    }

    @Override
    protected void actualLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IControllableServerBehavior beh = JBossServerBehaviorUtils.getControllableBehavior((ILaunchConfiguration)configuration);
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        String command = new RSELaunchConfigProperties().getStartupCommand(configuration);
        if (command.trim().length() == 0) {
            if (beh != null) {
                ((ControllableServerBehavior)beh).setServerStopped();
            }
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.rse.core", "Unable to start server: command to run is empty", null));
        }
        this.executeRemoteCommand(command, server);
    }

    @Override
    protected void afterVMRunner(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.pollServer(ServerUtil.getServer((ILaunchConfiguration)configuration), true);
    }

    @Override
    protected boolean isStarted(IServer server) {
        return PollThreadUtils.isServerStarted((IServer)server).isOK();
    }

    protected void pollServer(IServer server, boolean expectedState) {
        PollThreadUtils.pollServer((IServer)server, (boolean)expectedState);
    }
}

