/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import de.schlichtherle.io.ArchiveDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;
import org.jboss.ide.eclipse.as.core.util.FileUtil;
import org.jboss.ide.eclipse.as.wtp.core.server.publish.LocalZippedModulePublishRunner;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.test.util.JobUtils;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ZippedPublishRunnerTest
extends TestCase {
    private static IProject dummyProject;
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection(new Object[]{"org.jboss.ide.eclipse.as.systemCopyServer"});
    }

    public ZippedPublishRunnerTest(String serverType) {
        this.serverType = serverType;
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        dummyProject = ResourcesPlugin.getWorkspace().getRoot().getProject("Blah");
        dummyProject.create((IProgressMonitor)new NullProgressMonitor());
        dummyProject.open((IProgressMonitor)new NullProgressMonitor());
    }

    @Before
    public void setUp() throws Exception {
        try {
            this.server = ServerCreationTestUtils.createServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            throw ce;
        }
    }

    @After
    public void tearDown() throws Exception {
        JobUtils.waitForIdle((long)100L);
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
        ASMatrixTests.clearStateLocation();
        JobUtils.waitForIdle();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testSimpleWebModuleFull() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
    }

    @Test
    public void testSimpleWebModuleFullDirExists() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        dest.toFile().mkdirs();
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        FileUtil.safeDelete((File)dest.toFile());
        dest.toFile().mkdirs();
        runner.incrementalPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
    }

    @Test
    public void testSimpleWebModuleIncremental() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        IPath unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        String whtmlContents = IOUtil.getContents(unzipFolder.append("w.html").toFile());
        ZippedPublishRunnerTest.assertTrue((boolean)whtmlContents.equals("version1"));
        FileUtil.completeDelete((File)unzipFolder.toFile());
        final IModule web2 = web = this.createTestWebModule(2, false);
        runner = new LocalZippedModulePublishRunner(this.server, web, dest, null){

            protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
                try {
                    IModuleResource[] allResources = MockModuleUtil.getAllResources(web2);
                    IModuleResourceDelta[] delta = MockModuleUtil.createMockResourceDeltas(Arrays.asList(allResources), new IPath[]{new Path("w.html")}, new int[]{2});
                    return delta;
                }
                catch (Exception exception) {
                    return new IModuleResourceDelta[0];
                }
            }
        };
        runner.incrementalPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        whtmlContents = IOUtil.getContents(unzipFolder.append("w.html").toFile());
        ZippedPublishRunnerTest.assertTrue((boolean)whtmlContents.equals("version2"));
        String xhtmlContents = IOUtil.getContents(unzipFolder.append("x.html").toFile());
        ZippedPublishRunnerTest.assertEquals((String)xhtmlContents, (String)"version1");
    }

    @Test
    public void testSimpleWebModuleIncrementalFileRemoved() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        IPath unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        String whtmlContents = IOUtil.getContents(unzipFolder.append("w.html").toFile());
        ZippedPublishRunnerTest.assertTrue((boolean)whtmlContents.equals("version1"));
        FileUtil.completeDelete((File)unzipFolder.toFile());
        runner = this.testRunnerForDelta(web, dest, new IPath[]{new Path("w.html")}, new int[]{3});
        runner.incrementalPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(true)), true);
        unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        ZippedPublishRunnerTest.assertFalse((boolean)unzipFolder.append("w.html").toFile().exists());
        String xhtmlContents = IOUtil.getContents(unzipFolder.append("x.html").toFile());
        ZippedPublishRunnerTest.assertEquals((String)xhtmlContents, (String)"version1");
        ZippedPublishRunnerTest.assertTrue((boolean)unzipFolder.append("d/F/f1.html").toFile().exists());
        FileUtil.completeDelete((File)unzipFolder.toFile());
        runner = this.testRunnerForDelta(web, dest, new IPath[]{new Path("d/F/f1.html")}, new int[]{3});
        runner.incrementalPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(true)), true);
        unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        ZippedPublishRunnerTest.assertFalse((boolean)unzipFolder.append("w.html").toFile().exists());
        ZippedPublishRunnerTest.assertFalse((boolean)unzipFolder.append("d/F/f1.html").toFile().exists());
        FileUtil.completeDelete((File)unzipFolder.toFile());
    }

    private LocalZippedModulePublishRunner testRunnerForDelta(IModule mod, IPath dest, final IPath[] paths, final int[] kind) {
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, mod, dest, null){

            protected IModuleResourceDelta[] getDeltaForModule(IModule[] module) {
                try {
                    IModuleResource[] allResources = MockModuleUtil.getAllResources(module[module.length - 1]);
                    IModuleResourceDelta[] delta = MockModuleUtil.createMockResourceDeltas(Arrays.asList(allResources), paths, kind);
                    return delta;
                }
                catch (Exception exception) {
                    return new IModuleResourceDelta[0];
                }
            }
        };
        return runner;
    }

    @Test
    public void testSimpleWebModuleFullTwice() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        web = this.createTestWebModule(2, false);
        runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
        IPath unzipFolder = ASMatrixTests.getDefault().getStateLocation().append("unzip");
        unzipFolder.toFile().mkdirs();
        IOUtil.unzipFile(dest, unzipFolder);
        String whtmlContents = IOUtil.getContents(unzipFolder.append("w.html").toFile());
        ZippedPublishRunnerTest.assertTrue((boolean)whtmlContents.equals("version2"));
    }

    @Test
    public void testSimpleWebModuleIncrementalDNE() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("out.war");
        IModule web = this.createTestWebModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, web, dest, null);
        runner.incrementalPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getWebLeafs1(false)), true);
    }

    @Test
    public void testWebInEarModuleFull() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("MyEar.ear");
        IModule ear = this.createTestWebInEarModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        IPath webDest = dest.append("nested/inside/WebProj.war");
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), true);
    }

    @Test
    public void testWebInEarModuleRemoveWebFull() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("MyEar.ear");
        IModule ear = this.createTestWebInEarModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        IPath webDest = dest.append("nested/inside/WebProj.war");
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), true);
        ((MockModule)ear).clearChildren();
        runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), false);
    }

    @Test
    public void testEarModuleWebAddedFull() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("MyEar.ear");
        IModule ear = this.createTestWebInEarModule(1, false);
        ((MockModule)ear).clearChildren();
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        IPath webDest = dest.append("nested/inside/WebProj.war");
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), false);
        ear = this.createTestWebInEarModule(1, false);
        runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), true);
    }

    @Test
    public void testWebInEarModuleRemoveSomeFilesFull() throws Exception {
        IPath dest = ASMatrixTests.getDefault().getStateLocation().append("testDeploy").append("MyEar.ear");
        IModule ear = this.createTestWebInEarModule(1, false);
        LocalZippedModulePublishRunner runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(false)), true);
        IPath webDest = dest.append("nested/inside/WebProj.war");
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(false)), true);
        ear = this.createTestWebInEarModule(1, true);
        runner = new LocalZippedModulePublishRunner(this.server, ear, dest, null);
        runner.fullPublishModule((IProgressMonitor)new NullProgressMonitor());
        this.verifyList(dest, Arrays.asList(this.getEarLeafs1(true)), true);
        this.verifyList(webDest, Arrays.asList(this.getWebLeafs1(true)), true);
        IPath[] earFilesDeleted = this.getMissing(this.getEarLeafs1(false), this.getEarLeafs1(true));
        IPath[] webFilesDeleted = this.getMissing(this.getWebLeafs1(false), this.getWebLeafs1(true));
        this.verifyList(dest, Arrays.asList(earFilesDeleted), false);
        this.verifyList(webDest, Arrays.asList(webFilesDeleted), false);
    }

    protected void verifyList(IPath root, List<IPath> listOfRelativePaths, boolean exists) {
        Iterator<IPath> iterator = listOfRelativePaths.iterator();
        TrueZipUtil.JarArchiveDetector detector = new TrueZipUtil.JarArchiveDetector();
        while (iterator.hasNext()) {
            de.schlichtherle.io.File f = new de.schlichtherle.io.File(root.toFile(), (ArchiveDetector)detector);
            IPath nextRelative = iterator.next();
            de.schlichtherle.io.File toCheck = new de.schlichtherle.io.File((File)f, nextRelative.toString(), (ArchiveDetector)ArchiveDetector.DEFAULT);
            ZippedPublishRunnerTest.assertEquals((String)("File " + toCheck.getAbsolutePath() + (exists ? " should " : " should not ") + "exist"), (boolean)toCheck.exists(), (boolean)exists);
        }
    }

    private IPath[] getMissing(IPath[] all, IPath[] subset) {
        ArrayList<IPath> c = new ArrayList<IPath>();
        c.addAll(Arrays.asList(all));
        c.removeAll(Arrays.asList(subset));
        return c.toArray(new IPath[c.size()]);
    }

    private IPath[] getEarLeafs1(boolean ignoreSome) {
        IPath[] possiblyRemoved = new IPath[]{new Path("g.html"), new Path("h/q1.html"), new Path("i/b1.html"), new Path("j/F/f1.html")};
        IPath[] most = new IPath[]{new Path("g.html"), new Path("h/a1.html"), new Path("i/b2.html"), new Path("j/y1.html"), new Path("k/F/f4.html")};
        ArrayList<IPath> ret = new ArrayList<IPath>();
        ret.addAll(Arrays.asList(most));
        if (!ignoreSome) {
            ret.addAll(Arrays.asList(possiblyRemoved));
        }
        return ret.toArray(new IPath[ret.size()]);
    }

    private IPath[] getWebLeafs1(boolean ignoreSome) {
        IPath[] possiblyRemoved = new IPath[]{new Path("w.html"), new Path("a/q1.html"), new Path("b/b1.html"), new Path("d/F/f1.html")};
        IPath[] most = new IPath[]{new Path("x.html"), new Path("y.html"), new Path("z.html"), new Path("a/a1.html"), new Path("a/a2.html"), new Path("a/q2.html"), new Path("b/b2.html"), new Path("b/b3.html"), new Path("b/b4.html"), new Path("c/y1.html"), new Path("c/y2.html"), new Path("c/y3.html"), new Path("c/y4.html"), new Path("d/F/f2.html"), new Path("d/F/f3.html"), new Path("d/F/f4.html")};
        ArrayList<IPath> ret = new ArrayList<IPath>();
        ret.addAll(Arrays.asList(most));
        if (!ignoreSome) {
            ret.addAll(Arrays.asList(possiblyRemoved));
        }
        return ret.toArray(new IPath[ret.size()]);
    }

    private IModule createTestWebModule(int version, boolean ignoreSome) throws Exception {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + version);
        MockModule m = MockModuleUtil.createMockWebModule();
        IModuleResource[] all = MockModuleUtil.createMockResources(this.getWebLeafs1(ignoreSome), new IPath[0], underlying.toFile());
        m.setMembers(all);
        return m;
    }

    private IModule createTestWebInEarModule(int version, boolean ignoreSome) throws Exception {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + version);
        MockModule web = MockModuleUtil.createMockWebModule();
        IModuleResource[] webAll = MockModuleUtil.createMockResources(this.getWebLeafs1(ignoreSome), new IPath[0], underlying.toFile());
        web.setMembers(webAll);
        MockModule ear = MockModuleUtil.createMockEarModule();
        IModuleResource[] earAll = MockModuleUtil.createMockResources(this.getEarLeafs1(ignoreSome), new IPath[0], underlying.toFile());
        ear.setMembers(earAll);
        String webWithSuffix = String.valueOf(web.getName()) + ".war";
        String uri = "nested/inside/" + webWithSuffix;
        ear.addChildModule(web, uri);
        ear.setProject(dummyProject);
        return ear;
    }
}

