/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.JMXCoreMessages;
import org.jboss.tools.jmx.jolokia.JolokiaConnectionWrapper;
import org.jboss.tools.jmx.jolokia.internal.Activator;

public class JolokiaConnectionProvider
extends AbstractConnectionProvider
implements IConnectionProvider,
IConnectionCategory {
    public static final String PROVIDER_ID = "org.jboss.tools.jmx.jolokia.JolokiaConnectionProvider";
    private HashMap<String, JolokiaConnectionWrapper> connections;
    private static final String XML_FILE_NAME = "jolokiaconnections.xml";
    private static final String XML_ROOT = "JolokiaConnections";
    private static final String XML_CONNECTION = "connection";
    private static final String XML_HEADERS = "headers";
    private static final String XML_HEADER = "header";
    private static final String XML_ID = "id";
    private static final String XML_URL = "url";
    private static final String XML_IGNORE_SSL_ERR = "ignoreSSLError";
    private static final String XML_KEY = "key";
    private static final String XML_VALUE = "value";

    public String getId() {
        return PROVIDER_ID;
    }

    public String getName(IConnectionWrapper wrapper) {
        return ((JolokiaConnectionWrapper)wrapper).getName();
    }

    public IConnectionWrapper[] getConnections() {
        if (this.connections == null) {
            this.loadConnections();
        }
        if (this.connections != null) {
            ArrayList<JolokiaConnectionWrapper> result = new ArrayList<JolokiaConnectionWrapper>();
            result.addAll(this.connections.values());
            Collections.sort(result, new Comparator<IConnectionWrapper>(){

                @Override
                public int compare(IConnectionWrapper o1, IConnectionWrapper o2) {
                    String name1 = JolokiaConnectionProvider.this.getName(o1);
                    String name2 = JolokiaConnectionProvider.this.getName(o2);
                    if (name1 == null) {
                        return name2 == null ? 0 : -1;
                    }
                    if (name2 == null) {
                        return 1;
                    }
                    return name1.compareTo(name2);
                }
            });
            return result.toArray(new IConnectionWrapper[result.size()]);
        }
        return new IConnectionWrapper[0];
    }

    public IConnectionWrapper createConnection(Map map) throws CoreException {
        JolokiaConnectionWrapper con = new JolokiaConnectionWrapper();
        String id = (String)map.get(XML_ID);
        String url = (String)map.get(XML_URL);
        String type = (String)map.get("getOrPost");
        Boolean ignoreSSLError = (Boolean)map.get("ignoreSSLErrors");
        Map headers = (Map)map.get(XML_HEADERS);
        con.setId(id);
        con.setUrl(url);
        con.setHeaders(headers);
        con.setIgnoreSSLErrors(ignoreSSLError);
        con.setType(type == null ? "POST" : type);
        return con;
    }

    public boolean canCreate() {
        return true;
    }

    public boolean canDelete(IConnectionWrapper wrapper) {
        return true;
    }

    public void addConnection(IConnectionWrapper connection) {
        this.connections.put(((JolokiaConnectionWrapper)connection).getName(), (JolokiaConnectionWrapper)connection);
        try {
            this.fireAdded(connection);
            this.save();
        }
        catch (IOException ioe) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorAdding, (Throwable)ioe);
            Activator.pluginLog().logStatus((IStatus)s);
        }
    }

    public void removeConnection(IConnectionWrapper connection) {
        this.connections.remove(((JolokiaConnectionWrapper)connection).getName());
        try {
            this.fireRemoved(connection);
            this.save();
        }
        catch (IOException ioe) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorAdding, (Throwable)ioe);
            Activator.pluginLog().logStatus((IStatus)s);
        }
    }

    public void connectionChanged(IConnectionWrapper connection) {
        try {
            this.fireChanged(connection);
            this.save();
        }
        catch (IOException ioe) {
            Status s = new Status(4, "org.jboss.tools.jmx.core", JMXCoreMessages.DefaultConnection_ErrorAdding, (Throwable)ioe);
            Activator.pluginLog().logStatus((IStatus)s);
        }
    }

    private synchronized void loadConnections() {
        if (this.connections == null) {
            this.connections = new HashMap();
            IPath p = Activator.getDefault().getStateLocation().append(XML_FILE_NAME);
            if (p.toFile().exists()) {
                try {
                    XMLMemento mem = XMLMemento.createReadRoot((InputStream)new FileInputStream(p.toFile()));
                    IMemento[] mementoConnections = mem.getChildren(XML_CONNECTION);
                    int i = 0;
                    while (i < mementoConnections.length) {
                        String id = mementoConnections[i].getString(XML_ID);
                        String url = mementoConnections[i].getString(XML_URL);
                        boolean ignoreSSL = mementoConnections[i].getBoolean(XML_IGNORE_SSL_ERR);
                        IMemento headers = mementoConnections[i].getChild(XML_HEADERS);
                        HashMap<String, String> headerMap = new HashMap<String, String>();
                        if (headers != null) {
                            IMemento[] individualHeaders = headers.getChildren(XML_HEADER);
                            int j = 0;
                            while (j < individualHeaders.length) {
                                String key = individualHeaders[j].getString(XML_KEY);
                                String val = individualHeaders[j].getString(XML_VALUE);
                                headerMap.put(key, val);
                                ++j;
                            }
                        }
                        HashMap<String, Object> toCreate = new HashMap<String, Object>();
                        toCreate.put(XML_ID, id);
                        toCreate.put(XML_URL, url);
                        toCreate.put("ignoreSSLErrors", ignoreSSL);
                        toCreate.put(XML_HEADERS, headerMap);
                        try {
                            IConnectionWrapper created = this.createConnection(toCreate);
                            if (created != null) {
                                this.connections.put(id, (JolokiaConnectionWrapper)created);
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void save() throws IOException {
        XMLMemento mem = XMLMemento.createWriteRoot((String)XML_ROOT);
        for (String id : this.connections.keySet()) {
            JolokiaConnectionWrapper con = this.connections.get(id);
            id = con.getId();
            String url = con.getUrl();
            boolean ignoreSSLErr = con.isIgnoreSSLErrors();
            Map<String, String> headers = con.getHeaders();
            XMLMemento conMem = (XMLMemento)mem.createChild(XML_CONNECTION);
            conMem.putString(XML_ID, id);
            conMem.putString(XML_URL, url);
            conMem.putBoolean(XML_IGNORE_SSL_ERR, ignoreSSLErr);
            XMLMemento headersMem = (XMLMemento)conMem.createChild(XML_HEADERS);
            for (String hKey : headers.keySet()) {
                String hVal = headers.get(hKey);
                XMLMemento headerMem = (XMLMemento)headersMem.createChild(XML_HEADER);
                headerMem.putString(XML_KEY, hKey);
                headerMem.putString(XML_VALUE, hVal);
            }
        }
        IPath p = Activator.getDefault().getStateLocation().append(XML_FILE_NAME);
        p.toFile().getParentFile().mkdirs();
        mem.saveToFile(p.toOSString());
    }

    public String getCategoryId() {
        return "IConnectionCategory.defined";
    }

    public IConnectionWrapper findConnection(String name) {
        return this.connections.get(name);
    }
}

