/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.eclipse.wst.server.core.util.ModuleFile;
import org.eclipse.wst.server.core.util.ModuleFolder;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.modules.IJBTModule;

public class ModuleResourceUtil {
    public static int countChanges(IModuleResourceDelta[] deltas) {
        int count = 0;
        if (deltas == null) {
            return 0;
        }
        int i = 0;
        while (i < deltas.length) {
            IModuleResource res = deltas[i].getModuleResource();
            if (res != null && res instanceof IModuleFile) {
                ++count;
            }
            count += ModuleResourceUtil.countChanges(deltas[i].getAffectedChildren());
            ++i;
        }
        return count;
    }

    public static String getParentRelativeURI(IModule[] tree, int index, String defaultName) {
        String uri = null;
        if (index != 0) {
            IModule parent = tree[index - 1];
            IModule child = tree[index];
            ModuleDelegate md = (ModuleDelegate)parent.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            if (md instanceof IEnterpriseApplication) {
                uri = ((IEnterpriseApplication)md).getURI(child);
            } else if (md instanceof IJBTModule) {
                uri = ((IJBTModule)md).getURI(child);
            }
        }
        return uri == null ? defaultName : uri;
    }

    public static IModuleResource[] getResources(IModule module, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Fetching Module Resources", 100);
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, ProgressMonitorUtil.submon(monitor, 100));
        if (md == null) {
            return new IModuleResource[0];
        }
        IModuleResource[] members = md.members();
        monitor.done();
        return members;
    }

    public static IModuleResource[] getResources(IModule[] tree) throws CoreException {
        return ModuleResourceUtil.getResources(tree[tree.length - 1], (IProgressMonitor)new NullProgressMonitor());
    }

    public static File getFile(IModuleResource resource) {
        IFile ifile;
        File source = (File)resource.getAdapter(File.class);
        if (source == null && (ifile = (IFile)resource.getAdapter(IFile.class)) != null) {
            source = ifile.getLocation().toFile();
        }
        return source;
    }

    public static File getFile(IModuleFile mf) {
        return (IFile)mf.getAdapter(IFile.class) != null ? ((IFile)mf.getAdapter(IFile.class)).getLocation().toFile() : (File)mf.getAdapter(File.class);
    }

    public static IModule[] combine(IModule[] module, IModule newMod) {
        IModule[] retval = new IModule[module.length + 1];
        int i = 0;
        while (i < module.length) {
            retval[i] = module[i];
            ++i;
        }
        retval[retval.length - 1] = newMod;
        return retval;
    }

    public static IModuleResource createResource(IResource resource) {
        return ModuleResourceUtil.createResource(resource, (IPath)new Path("/"));
    }

    public static IModuleResource createResource(IResource resource, IPath path) {
        if (resource instanceof IFile) {
            return ModuleResourceUtil.createFile((IFile)resource, path);
        }
        IContainer cont = (IContainer)resource;
        return ModuleResourceUtil.createFolder(cont, path);
    }

    public static IModuleResource createFile(IFile resource, IPath path) {
        IPath global = resource.getLocation();
        return new ModuleFile(global.toFile(), global.lastSegment(), path);
    }

    public static IModuleResource createFolder(IContainer cont, IPath path) {
        ModuleFolder folder = new ModuleFolder(cont, cont.getName(), path);
        IModuleResource[] childrenResources = ModuleResourceUtil.createChildrenResources(cont, path.append(cont.getName()));
        folder.setMembers(childrenResources);
        return folder;
    }

    public static IModuleResource[] createChildrenResources(IContainer parent, IPath forcedParentPath) {
        ArrayList<IModuleResource> modChildren = new ArrayList<IModuleResource>();
        IResource[] children = new IResource[]{};
        try {
            children = parent.members();
        }
        catch (CoreException ce) {
            ASWTPToolsPlugin.log(ce.getStatus());
        }
        int i = 0;
        while (i < children.length) {
            modChildren.add(ModuleResourceUtil.createResource(children[i], forcedParentPath));
            ++i;
        }
        return modChildren.toArray(new IModuleResource[modChildren.size()]);
    }

    public static IModuleResource[] addFileToModuleResources(IModule[] moduleTree, IPath prevPath, IModuleResource[] resources, IPath remainingPath, File childFile) {
        ModuleFolder mf;
        boolean found = false;
        String name = remainingPath.segment(0);
        remainingPath = remainingPath.removeFirstSegments(1);
        int i = 0;
        while (i < resources.length) {
            if (resources[i].getName().equals(remainingPath.segment(0))) {
                found = true;
                if (resources[i] instanceof IModuleFile) {
                    resources[i] = new ModuleFile(childFile, name, prevPath);
                    return resources;
                }
                if (resources[i] instanceof IModuleFolder) {
                    mf = (IModuleFolder)resources[i];
                    IModuleResource[] mfChildren = mf.members();
                    IModuleResource[] newChildren = ModuleResourceUtil.addFileToModuleResources(moduleTree, prevPath.append(name), mfChildren, remainingPath, childFile);
                    mf.setMembers(newChildren);
                }
            }
            ++i;
        }
        if (found) {
            return resources;
        }
        IModuleResource[] newResources = new IModuleResource[resources.length + 1];
        System.arraycopy(resources, 0, newResources, 0, resources.length);
        if (remainingPath.segmentCount() == 0) {
            newResources[newResources.length - 1] = new ModuleFile(childFile, name, prevPath);
        } else {
            mf = new ModuleFolder(null, name, prevPath);
            IModuleResource[] newChildren = ModuleResourceUtil.addFileToModuleResources(moduleTree, prevPath.append(name), new IModuleResource[0], remainingPath, childFile);
            mf.setMembers(newChildren);
            newResources[newResources.length - 1] = mf;
        }
        return newResources;
    }

    public static int countMembers(IModule module) {
        IModuleResource[] resources;
        ModuleDelegate delegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        try {
            resources = delegate.members();
        }
        catch (CoreException ce) {
            resources = new IModuleResource[]{};
        }
        return delegate == null ? 0 : ModuleResourceUtil.countMembers(resources);
    }

    public static int countMembers(IModuleResource[] resources) {
        return ModuleResourceUtil.countMembers(resources, false);
    }

    public static int countMembers(IModuleResource[] resources, boolean includeFolders) {
        int count = 0;
        if (resources == null) {
            return 0;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IModuleFile) {
                ++count;
            } else if (resources[i] instanceof IModuleFolder) {
                count += ModuleResourceUtil.countMembers(((IModuleFolder)resources[i]).members(), includeFolders);
                if (includeFolders) {
                    ++count;
                }
            }
            ++i;
        }
        return count;
    }

    public static IModuleResource[] getMembers(IModule module) throws CoreException {
        ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
        return md == null ? new IModuleResource[]{} : md.members();
    }
}

