/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ProgressMonitorUtil {
    public static IProgressMonitor getSubMon(IProgressMonitor parent, int ticks) {
        CustomSubProgress subMon = new CustomSubProgress(parent, ticks, 4);
        return subMon;
    }

    public static IProgressMonitor getMonitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks) {
        return ProgressMonitorUtil.submon(parent, ticks, 2);
    }

    public static IProgressMonitor submon(IProgressMonitor parent, int ticks, int style) {
        return parent == null ? new NullProgressMonitor() : new SubProgressMonitor(parent, ticks, style);
    }

    public static void subTask(IProgressMonitor monitor, String taskName) {
        if (monitor != null) {
            monitor.subTask(taskName);
        }
    }

    public static void checkIfCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor != null && monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    public static class CustomSubProgress
    extends SubProgressMonitor {
        public CustomSubProgress(IProgressMonitor monitor, int ticks, int style) {
            super(monitor, ticks, style);
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(null, totalWork);
            this.setTaskName(name);
        }
    }
}

