/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.IDelegatingServerBehavior;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IDeployableServerBehaviour;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.wtp.core.Messages;

public class ServerConverter {
    public static IServer findServer(String serverId) {
        if (serverId == null) {
            return null;
        }
        return ServerCore.findServer((String)serverId);
    }

    public static IJBossServer findJBossServer(String serverId) throws CoreException {
        if (serverId == null) {
            return null;
        }
        IServer s = ServerCore.findServer((String)serverId);
        if (s == null) {
            return null;
        }
        return ServerConverter.getJBossServer(s);
    }

    public static IJBossServer checkedFindJBossServer(String serverId) throws CoreException {
        IJBossServer server = ServerConverter.findJBossServer(serverId);
        if (server == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.CouldNotFindServer, (Object)serverId)));
        }
        return server;
    }

    public static <SERVER> SERVER checkedGetJBossServer(IServer server, Class<SERVER> serverClass) throws CoreException {
        return ServerConverter.checkedConvertServer((IServerAttributes)server, serverClass);
    }

    public static <SERVER> SERVER checkedConvertServer(IServerAttributes server, Class<SERVER> serverClass) throws CoreException {
        SERVER adaptedServer = ServerConverter.convertServer(server, serverClass);
        if (adaptedServer == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.CannotSetUpImproperServer, (Object)server.getName())));
        }
        return adaptedServer;
    }

    public static <SERVER> SERVER convertServer(IServerAttributes server, Class<SERVER> serverClass) {
        if (server == null) {
            return null;
        }
        Object adaptedServer = server.loadAdapter(serverClass, (IProgressMonitor)new NullProgressMonitor());
        return (SERVER)adaptedServer;
    }

    public static IJBossServer getJBossServer(IServer server) {
        return ServerConverter.convertServer((IServerAttributes)server, IJBossServer.class);
    }

    public static IJBossServer checkedGetJBossServer(IServer server) throws CoreException {
        return ServerConverter.checkedConvertServer((IServerAttributes)server, IJBossServer.class);
    }

    public static IJBossServer getJBossServer(IServerWorkingCopy server) {
        return ServerConverter.convertServer((IServerAttributes)server, IJBossServer.class);
    }

    public static IDeployableServer getDeployableServer(IServerAttributes server) {
        return ServerConverter.convertServer(server, IDeployableServer.class);
    }

    public static IDeployableServerBehaviour getDeployableServerBehavior(IServer server) {
        return ServerConverter.convertServer((IServerAttributes)server, IDeployableServerBehaviour.class);
    }

    public static IDelegatingServerBehavior getJBossServerBehavior(IServer server) {
        return ServerConverter.convertServer((IServerAttributes)server, IDelegatingServerBehavior.class);
    }

    public static IJBossServer[] getAllJBossServers() {
        ArrayList<IJBossServer> servers = new ArrayList<IJBossServer>();
        IServer[] iservers = ServerCore.getServers();
        int i = 0;
        while (i < iservers.length) {
            if (ServerConverter.getJBossServer(iservers[i]) != null) {
                servers.add(ServerConverter.getJBossServer(iservers[i]));
            }
            ++i;
        }
        IJBossServer[] ret = new IJBossServer[servers.size()];
        servers.toArray(ret);
        return ret;
    }

    public static IServer[] getJBossServersAsIServers() {
        ArrayList<IServer> servers = new ArrayList<IServer>();
        IServer[] iservers = ServerCore.getServers();
        int i = 0;
        while (i < iservers.length) {
            if (ServerConverter.getJBossServer(iservers[i]) != null) {
                servers.add(iservers[i]);
            }
            ++i;
        }
        IServer[] ret = new IServer[servers.size()];
        servers.toArray(ret);
        return ret;
    }

    public static IDeployableServer[] getAllDeployableServers() {
        ArrayList<IDeployableServer> servers = new ArrayList<IDeployableServer>();
        IServer[] iservers = ServerCore.getServers();
        int i = 0;
        while (i < iservers.length) {
            if (ServerConverter.getDeployableServer((IServerAttributes)iservers[i]) != null) {
                servers.add(ServerConverter.getDeployableServer((IServerAttributes)iservers[i]));
            }
            ++i;
        }
        IDeployableServer[] ret = new IDeployableServer[servers.size()];
        servers.toArray(ret);
        return ret;
    }

    public static IServer[] getDeployableServersAsIServers() {
        ArrayList<IServer> servers = new ArrayList<IServer>();
        IServer[] iservers = ServerCore.getServers();
        int i = 0;
        while (i < iservers.length) {
            if (ServerConverter.getDeployableServer((IServerAttributes)iservers[i]) != null) {
                servers.add(iservers[i]);
            }
            ++i;
        }
        IServer[] ret = new IServer[servers.size()];
        servers.toArray(ret);
        return ret;
    }
}

