/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.debug;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.jboss.ide.eclipse.as.wtp.core.debug.AttachDebuggerServerListener;
import org.jboss.tools.foundation.core.plugin.log.StatusFactory;

public class RemoteDebugUtils {
    public static final String ATTACH_DEBUGGER = "org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.ATTACH_DEBUGGER";
    public static final String DEBUG_PORT = "org.jboss.ide.eclipse.as.core.server.launch.DebugLaunchConstants.DEBUG_PORT";
    public static final int DEFAULT_DEBUG_PORT = 8787;
    private ILaunchManager launchManager;

    public static RemoteDebugUtils get() {
        return RemoteDebugUtils.get(DebugPlugin.getDefault().getLaunchManager());
    }

    public static RemoteDebugUtils get(ILaunchManager launchManager) {
        return new RemoteDebugUtils(launchManager);
    }

    private RemoteDebugUtils(ILaunchManager launchManager) {
        this.launchManager = launchManager;
    }

    public ILaunchConfiguration getRemoteDebuggerLaunchConfiguration(IServer server) throws CoreException {
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfiguration[] launchConfigs = this.launchManager.getLaunchConfigurations(launchConfigurationType);
        String name = RemoteDebugUtils.getRemoteDebuggerLaunchConfigurationName(server);
        Stream.of(launchConfigs);
        Optional<ILaunchConfiguration> maybeLaunch = Stream.of(launchConfigs).filter(lc -> name.equals(lc.getName())).findFirst();
        return maybeLaunch.orElse(null);
    }

    public ILaunchConfigurationWorkingCopy createRemoteDebuggerLaunchConfiguration(IServer server) throws CoreException {
        String name = RemoteDebugUtils.getRemoteDebuggerLaunchConfigurationName(server);
        ILaunchConfigurationType launchConfigurationType = this.launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_REMOTE_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, name);
        return workingCopy;
    }

    public void setupRemoteDebuggerLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProject project, int debugPort, String host) throws CoreException {
        String portString = String.valueOf(debugPort);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, IJavaLaunchConfigurationConstants.ID_SOCKET_ATTACH_VM_CONNECTOR);
        HashMap<String, String> connectMap = new HashMap<String, String>(2);
        connectMap.put("port", portString);
        connectMap.put("hostname", host);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, connectMap);
        if (project != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        }
    }

    public boolean isRunning(ILaunchConfiguration launchConfiguration, int localDebugPort) {
        boolean isRunning = this.getLaunches().filter(l -> !l.isTerminated() && this.launchMatches((ILaunch)l, launchConfiguration, localDebugPort)).findFirst().isPresent();
        return isRunning;
    }

    private boolean launchMatches(ILaunch l, ILaunchConfiguration launchConfiguration, int localDebugPort) {
        return Objects.equals(l.getLaunchConfiguration(), launchConfiguration);
    }

    public static String getRemoteDebuggerLaunchConfigurationName(IServer server) {
        String name = "Remote debugger to " + server.getName();
        return name;
    }

    public void terminateRemoteDebugger(IServer server) throws CoreException {
        ILaunchConfiguration launchConfig = this.getRemoteDebuggerLaunchConfiguration(server);
        if (launchConfig == null) {
            return;
        }
        ArrayList errors = new ArrayList();
        this.getLaunches().filter(l -> launchConfig.equals(l.getLaunchConfiguration())).filter(l -> l.canTerminate()).forEach(l -> this.terminate((ILaunch)l, errors));
        if (!errors.isEmpty()) {
            MultiStatus status = new MultiStatus("org.jboss.ide.eclipse.as.wtp.core", 4, errors.toArray(new IStatus[errors.size()]), "Failed to terminate remote launch configuration", null);
            throw new CoreException((IStatus)status);
        }
    }

    private void terminate(ILaunch launch, Collection<IStatus> errors) {
        try {
            launch.terminate();
        }
        catch (DebugException e) {
            errors.add(e.getStatus());
        }
    }

    private Stream<ILaunch> getLaunches() {
        return Stream.of(this.launchManager.getLaunches());
    }

    public IServerListener createAttachDebuggerListener() {
        return this.createAttachDebuggerListener(true);
    }

    public IServerListener createAttachDebuggerListener(boolean register) {
        return new AttachDebuggerServerListener(register);
    }

    protected int getDebugPort(IServer server) {
        String debugPort = server.getAttribute(DEBUG_PORT, Integer.toString(8787));
        int port = -1;
        try {
            port = Integer.parseInt(debugPort);
        }
        catch (NumberFormatException nfe) {
            port = 8787;
        }
        if (port < 1) {
            port = 8787;
        }
        return port;
    }

    public ILaunch attachRemoteDebugger(IServer server, IProgressMonitor monitor) throws CoreException {
        return this.attachRemoteDebugger(server, this.getDebugPort(server), monitor);
    }

    public ILaunch attachRemoteDebugger(IServer server, int localDebugPort, IProgressMonitor monitor) throws CoreException {
        return this.attachRemoteDebugger(server, localDebugPort, true, monitor);
    }

    public ILaunch attachRemoteDebugger(IServer server, int localDebugPort, boolean register, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy;
        monitor.subTask("Attaching remote debugger");
        ILaunch ret = null;
        RemoteDebugUtils debugUtils = RemoteDebugUtils.get();
        ILaunchConfiguration debuggerLaunchConfig = debugUtils.getRemoteDebuggerLaunchConfiguration(server);
        if (debuggerLaunchConfig == null) {
            workingCopy = debugUtils.createRemoteDebuggerLaunchConfiguration(server);
        } else {
            if (debugUtils.isRunning(debuggerLaunchConfig, localDebugPort)) {
                return null;
            }
            workingCopy = debuggerLaunchConfig.getWorkingCopy();
        }
        debugUtils.setupRemoteDebuggerLaunchConfiguration(workingCopy, null, localDebugPort, server.getHost());
        debuggerLaunchConfig = workingCopy.doSave();
        Exception eSaved = null;
        boolean launched = false;
        try {
            ret = register ? debuggerLaunchConfig.launch("debug", (IProgressMonitor)new NullProgressMonitor()) : debuggerLaunchConfig.launch("debug", monitor, false, false);
            launched = true;
        }
        catch (Exception e) {
            eSaved = e;
        }
        if (!launched) {
            throw this.toCoreException("Unable to start a remote debugger to " + server.getHost() + ":" + localDebugPort, eSaved);
        }
        monitor.worked(10);
        return ret;
    }

    private CoreException toCoreException(String msg, Exception e) {
        return new CoreException(StatusFactory.errorStatus((String)"org.jboss.ide.eclipse.as.wtp.core", (String)msg, (Throwable)e));
    }

    private CoreException toCoreException(String msg) {
        return this.toCoreException(msg, null);
    }
}

