/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.publish;

import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;

public class ModulePublishErrorCache {
    private static ModulePublishErrorCache cache = new ModulePublishErrorCache();
    private HashMap<String, ServerResults> model = new HashMap();

    public static ModulePublishErrorCache getDefault() {
        return cache;
    }

    public IStatus getPublishErrorStatus(IServer server, IModule[] module) {
        ModuleContainer mc = new ModuleContainer(module);
        ServerResults sr = this.model.get(server.getId());
        IStatus s = null;
        if (sr != null) {
            s = sr.getPublishErrorStatusForModule(mc);
        }
        return s == null ? Status.OK_STATUS : s;
    }

    public void setPublishErrorState(IServer server, IModule[] module, int state, IStatus status) {
        ModuleContainer mc = new ModuleContainer(module);
        ServerResults sr = this.model.get(server.getId());
        if (sr == null) {
            sr = new ServerResults();
            this.model.put(server.getId(), sr);
        }
        sr.addStatusForModule(mc, state, status);
    }

    private static class ModuleContainer {
        private IModule[] mod;
        private String stringRep;

        public ModuleContainer(IModule[] module) {
            this.mod = module;
            this.stringRep = this.toString();
        }

        public int hashCode() {
            return this.stringRep.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ModuleContainer && ((ModuleContainer)other).toString().equals(this.stringRep);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.mod.length) {
                sb.append(this.mod[i].getId());
                if (i == this.mod.length - 1) {
                    sb.append("\n");
                }
                ++i;
            }
            return sb.toString();
        }
    }

    private static class ServerResults {
        private HashMap<ModuleContainer, Integer> perModuleState = new HashMap();
        private HashMap<ModuleContainer, IStatus> perModuleStatus = new HashMap();

        public Integer getPublishErrorStateForModule(ModuleContainer mc) {
            return this.perModuleState.get(mc);
        }

        public IStatus getPublishErrorStatusForModule(ModuleContainer mc) {
            return this.perModuleStatus.get(mc);
        }

        public void addStatusForModule(ModuleContainer mc, Integer result, IStatus status) {
            this.perModuleState.put(mc, result);
            this.perModuleStatus.put(mc, status);
        }
    }
}

