/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.publish;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.ide.eclipse.as.core.util.ProgressMonitorUtil;
import org.jboss.ide.eclipse.as.wtp.core.Trace;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;

public final class PublishModuleIncrementalRunner {
    private static final IStatus[] EMPTY_STATUS = new IStatus[0];
    private static final IStatus CANCEL_STATUS = new Status(8, "org.jboss.ide.eclipse.as.wtp.core", "Publish Canceled");
    private static final IStatus[] CANCEL_STATUS_ARR = new IStatus[]{CANCEL_STATUS};
    private IFilesystemController fsController;
    private IPath rootDirectory;

    public PublishModuleIncrementalRunner(IFilesystemController fsController, IPath rootDirectory) {
        this.fsController = fsController;
        this.rootDirectory = rootDirectory;
    }

    public IStatus[] publish(IModuleResourceDelta[] delta, IProgressMonitor monitor) throws CoreException {
        if (delta == null) {
            return EMPTY_STATUS;
        }
        Trace.trace("/finer", "      Executing incremental publish on module.");
        int count = ModuleResourceUtil.countChanges(delta);
        Trace.trace("/finer", "      Resources to be copied: " + count);
        monitor = ProgressMonitorUtil.getMonitorFor(monitor);
        monitor.beginTask("Incremental Publish", count * 100);
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        int size2 = delta.length;
        int i = 0;
        while (i < size2) {
            if (monitor.isCanceled()) {
                return CANCEL_STATUS_ARR;
            }
            IStatus[] stat = this.publishDelta(delta[i], this.rootDirectory, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            PublishModuleIncrementalRunner.addArrayToList(status, stat);
            ++i;
        }
        return status.toArray(new IStatus[status.size()]);
    }

    private IStatus[] publishDelta(IModuleResourceDelta delta, IPath root, IProgressMonitor monitor) throws CoreException {
        IStatus stat;
        ArrayList<IStatus> status = new ArrayList<IStatus>(2);
        if (monitor.isCanceled()) {
            return CANCEL_STATUS_ARR;
        }
        IModuleResource resource = delta.getModuleResource();
        int kind2 = delta.getKind();
        IPath absolutePath = root.append(resource.getModuleRelativePath()).append(resource.getName());
        if (resource instanceof IModuleFile) {
            IModuleFile file = (IModuleFile)resource;
            File ioFile = ModuleResourceUtil.getFile(file);
            if (kind2 == 3) {
                Trace.trace("/finer", "      Removing resource: " + absolutePath);
                IStatus stat2 = this.fsController.deleteResource(absolutePath, monitor);
                if (stat2 != null) {
                    status.add(stat2);
                }
            } else if (kind2 != 0) {
                Trace.trace("/finer", "      Creating directory resource: " + absolutePath.removeLastSegments(1));
                IStatus s1 = this.fsController.makeDirectoryIfRequired(absolutePath.removeLastSegments(1), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (s1 != null) {
                    status.add(s1);
                }
                if (monitor.isCanceled()) {
                    return CANCEL_STATUS_ARR;
                }
                Trace.trace("/finer", "      Copying resource: " + absolutePath);
                IStatus s2 = this.fsController.copyFile(ioFile, absolutePath, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                if (s2 != null) {
                    status.add(s2);
                }
            }
            return status.toArray(new IStatus[status.size()]);
        }
        if (kind2 == 1) {
            Trace.trace("/finer", "      Creating directory resource: " + absolutePath);
            IStatus stat3 = this.fsController.makeDirectoryIfRequired(absolutePath, monitor);
            if (stat3 != null) {
                status.add(stat3);
            }
        }
        IModuleResourceDelta[] childDeltas = delta.getAffectedChildren();
        int size = childDeltas.length;
        int i = 0;
        while (i < size) {
            if (monitor.isCanceled()) {
                return CANCEL_STATUS_ARR;
            }
            IStatus[] stat4 = this.publishDelta(childDeltas[i], root, monitor);
            PublishModuleIncrementalRunner.addArrayToList(status, stat4);
            ++i;
        }
        if (kind2 == 3 && (stat = this.fsController.deleteResource(absolutePath, monitor)) != null && !stat.isOK()) {
            String msg = NLS.bind((String)Messages.errorDeleting, (Object)absolutePath);
            Throwable t = stat.getException() == null ? new Exception(msg) : stat.getException();
            status.add((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 1644298251, msg, t));
        }
        return status.toArray(new IStatus[status.size()]);
    }

    private static void addArrayToList(List<IStatus> list, IStatus[] a) {
        if (a != null && a.length != 0) {
            list.addAll(Arrays.asList(a));
        }
    }
}

