/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetComposite;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.Fileset;

public class FilesetDialog
extends TitleAreaDialog
implements FilesetComposite.IFilesetCompositeErrorDisplay {
    protected Fileset fileset;
    private FilesetComposite main;
    private boolean showViewer = true;

    protected FilesetDialog(Shell parentShell, String defaultLocation, IServer server) {
        super(parentShell);
        this.fileset = new Fileset();
        this.fileset.setFolder(defaultLocation);
        this.fileset.setServer(server);
        this.fileset.setIncludesPattern(this.getDefaultIncludesPattern());
    }

    protected FilesetDialog(Shell parentShell, Fileset fileset) {
        super(parentShell);
        this.fileset = (Fileset)fileset.clone();
    }

    protected String getDefaultIncludesPattern() {
        return "**/*.xml";
    }

    public void setShowViewer(boolean val) {
        this.showViewer = val;
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return new Point(500, p.y);
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.FilesetsNewFileset);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.FilesetsDialogTitle);
        this.setMessage(Messages.FilesetsDialogMessage);
        Composite sup = (Composite)super.createDialogArea(parent);
        this.main = new FilesetComposite(sup, this.fileset, this.showViewer);
        this.main.setLayoutData(new GridData(1808));
        this.main.setErrorDisplay(this);
        this.getShell().layout();
        this.updateError(this.main.getValidationError());
        return sup;
    }

    public void updateError(String msg) {
        this.setErrorMessage(msg);
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(msg == null);
        }
    }

    public void create() {
        super.create();
        this.updateError(this.main.getValidationError());
    }

    public String getDir() {
        return this.main.getDir();
    }

    public String getExcludes() {
        return this.main.getExcludes();
    }

    public String getIncludes() {
        return this.main.getIncludes();
    }

    public String getName() {
        return this.main.getName();
    }

    public Fileset getFileset() {
        return this.main.getFileset();
    }
}

