/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.filesets;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.jboss.ide.eclipse.archives.webtools.IntegrationPlugin;
import org.jboss.ide.eclipse.archives.webtools.filesets.FilesetContentProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.Fileset;

public class FilesetLabelProvider
extends LabelProvider {
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Image rootImage;

    public FilesetLabelProvider() {
        ImageDescriptor des = ImageDescriptor.createFromURL((URL)IntegrationPlugin.getDefault().getBundle().getEntry("icons/multiple_files.gif"));
        this.rootImage = des.createImage();
    }

    public Image getImage(Object element) {
        if (element instanceof Fileset) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof FilesetContentProvider.FolderWrapper) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof FilesetContentProvider.PathWrapper) {
            String fileName = ((FilesetContentProvider.PathWrapper)element).getPath().toOSString();
            IContentTypeManager manager = Platform.getContentTypeManager();
            IContentTypeMatcher matcher = manager.getMatcher(null, null);
            IContentType contentType = matcher.findContentTypeFor(fileName);
            ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(fileName, contentType);
            if (descriptor == null) {
                descriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE");
            }
            return this.resourceManager.createImage(descriptor);
        }
        if (element instanceof FilesetContentProvider.ServerWrapper) {
            return this.rootImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof FilesetContentProvider.PathWrapper) {
            return ((FilesetContentProvider.PathWrapper)element).getLocalizedResourceName();
        }
        if (element instanceof Fileset) {
            return String.valueOf(((Fileset)element).getName()) + "  " + ((Fileset)element).getRawFolder();
        }
        if (element instanceof FilesetContentProvider.ServerWrapper) {
            return "Filesets";
        }
        return null;
    }

    public void dispose() {
        this.resourceManager.dispose();
        this.resourceManager = null;
        this.rootImage.dispose();
        super.dispose();
    }
}

