/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.webtools.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.actions.INodeActionDelegate;
import org.jboss.ide.eclipse.archives.webtools.Messages;
import org.jboss.ide.eclipse.archives.webtools.modules.ArchivesModuleModelListener;
import org.jboss.ide.eclipse.archives.webtools.ui.ArchivePublishWizard;

public class PublishAction
implements INodeActionDelegate {
    public void run(IArchiveNode node) {
        if (node.getNodeType() == 0 && ((IArchive)node).isTopLevel()) {
            final IArchive pkg = (IArchive)node;
            String servers = node.getProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployServers");
            if (servers == null || "".equals(servers) || this.anyServerDoesntExist(servers)) {
                servers = this.showSelectServersDialog(pkg);
            }
            final String servers2 = servers;
            if (servers != null) {
                Job j = new Job(Messages.BuildArchive){

                    protected IStatus run(IProgressMonitor monitor) {
                        ArchivesModuleModelListener.getInstance().publish(pkg, servers2, 2);
                        return Status.OK_STATUS;
                    }
                };
                j.schedule();
            }
        }
    }

    protected boolean anyServerDoesntExist(String servers) {
        String[] asArray = servers.split(",");
        int i = 0;
        while (i < asArray.length) {
            if (ServerCore.findServer((String)asArray[i]) == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnabledFor(IArchiveNode node) {
        IArchive pkg;
        return node.getNodeType() == 0 && (pkg = (IArchive)node).isTopLevel();
    }

    protected String showSelectServersDialog(IArchive node) {
        ArchivePublishWizard wiz = new ArchivePublishWizard(node);
        int result = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wiz).open();
        if (result == 0) {
            return wiz.getServers();
        }
        return null;
    }
}

