/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.util.composites;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.util.composites.ArchiveNodeDestinationDialog;

public class ArchiveFilesetDestinationComposite {
    protected Composite parent;
    protected Label destinationImage;
    protected Text destinationText;
    protected Object nodeDestination;
    private Label destinationKey;
    private Composite browseComposite;

    public ArchiveFilesetDestinationComposite(Composite parent, int style, Object destination) {
        this.parent = parent;
        this.nodeDestination = destination;
        this.createComposite();
    }

    protected void createComposite() {
        this.destinationKey = new Label(this.parent, 0);
        this.destinationKey.setText(ArchivesUIMessages.FilesetInfoWizardPage_destination_label);
        this.destinationKey.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.destinationImage = new Label(this.parent, 0);
        this.browseComposite = new Composite(this.parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.browseComposite.setLayout((Layout)gl);
        this.browseComposite.setLayoutData((Object)new GridData(768));
        this.destinationText = new Text(this.browseComposite, 2048);
        this.destinationText.setEditable(false);
        this.destinationText.setLayoutData((Object)new GridData(768));
        Button filesystemBrowseButton = new Button(this.browseComposite, 8);
        filesystemBrowseButton.setText(ArchivesUIMessages.PackageDestinationComposite_workspaceBrowseButton_label);
        filesystemBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveFilesetDestinationComposite.this.openDestinationDialog();
            }
        });
        this.updateDestinationViewer();
    }

    public void setPackageNodeDestination(Object destination) {
        this.nodeDestination = destination;
        this.updateDestinationViewer();
    }

    protected void updateDestinationViewer() {
        if (this.nodeDestination == null) {
            return;
        }
        this.destinationText.setText("");
        if (this.nodeDestination instanceof IArchive) {
            IArchive pkg = (IArchive)this.nodeDestination;
            String txt = pkg.isTopLevel() ? pkg.getName() : pkg.getRootArchiveRelativePath().toOSString();
            String imgKey = pkg.isExploded() ? "icons/jar_exploded_obj.gif" : "icons/jar_obj.gif";
            this.destinationText.setText(txt);
            this.destinationImage.setImage(ArchivesSharedImages.getImage(imgKey));
        } else if (this.nodeDestination instanceof IArchiveFolder) {
            IArchiveFolder folder = (IArchiveFolder)this.nodeDestination;
            this.destinationText.setText(folder.getRootArchiveRelativePath().toString());
            this.destinationImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        } else if (this.nodeDestination instanceof IProject) {
            IProject project = (IProject)this.nodeDestination;
            this.destinationText.setText(project.getName());
            this.destinationImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT"));
        } else if (this.nodeDestination instanceof IFolder) {
            IFolder folder = (IFolder)this.nodeDestination;
            this.destinationText.setText(String.valueOf('/') + folder.getProject().getName() + '/' + folder.getProjectRelativePath().toString());
            this.destinationImage.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"));
        }
    }

    public Object getPackageNodeDestination() {
        return this.nodeDestination;
    }

    protected void openDestinationDialog() {
        ArchiveNodeDestinationDialog dialog = new ArchiveNodeDestinationDialog(this.parent.getShell(), false, true);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length == 1 && selection[0] instanceof IArchiveNode && !(selection[0] instanceof IArchiveFileSet)) {
                    return Status.OK_STATUS;
                }
                return new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesUIMessages.SelectionNotValid);
            }
        });
        if (this.nodeDestination != null) {
            dialog.setInitialSelection(this.nodeDestination);
        }
        if (dialog.open() == 0) {
            this.setPackageNodeDestination(dialog.getResult()[0]);
        }
    }
}

