/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.util.composites.ArchiveSourceDestinationComposite;
import org.jboss.ide.eclipse.archives.ui.wizards.AbstractArchiveWizard;
import org.jboss.ide.eclipse.archives.ui.wizards.WizardPageWithNotification;

public class ArchiveInfoWizardPage
extends WizardPageWithNotification {
    private AbstractArchiveWizard wizard;
    private Text packageNameText;
    private Button compressedButton;
    private Button explodedButton;
    private String packageName;
    private boolean packageExploded;
    private ArchiveSourceDestinationComposite destinationComposite;
    private IArchive archive;

    public ArchiveInfoWizardPage(AbstractArchiveWizard wizard, IArchive existingPackage) {
        super(ArchivesUIMessages.PackageInfoWizardPage_title, ArchivesUIMessages.PackageInfoWizardPage_title, wizard.getImageDescriptor());
        this.setWizard(wizard);
        this.archive = existingPackage;
    }

    public void createControl(Composite parent) {
        this.setMessage(ArchivesUIMessages.PackageInfoWizardPage_message);
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        Group infoGroup = new Group(main, 0);
        infoGroup.setLayout((Layout)new GridLayout(3, false));
        infoGroup.setText(ArchivesUIMessages.PackageInfoWizardPage_infoGroup_label);
        this.expand((Control)infoGroup);
        Label archName = new Label((Composite)infoGroup, 0);
        archName.setText(ArchivesUIMessages.PackageInfoWizardPage_packageName_label);
        archName.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label archImage = new Label((Composite)infoGroup, 0);
        archImage.setImage(ArchivesSharedImages.getImage("icons/jar_obj.gif"));
        this.packageNameText = new Text((Composite)infoGroup, 2048);
        this.packageName = String.valueOf(this.wizard.getProject().getName()) + "." + this.wizard.getArchiveExtension();
        this.packageNameText.setText(this.packageName);
        this.packageNameText.setSelection(0, this.wizard.getProject().getName().length());
        this.expand((Control)this.packageNameText);
        this.packageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ArchiveInfoWizardPage.this.validate()) {
                    ArchiveInfoWizardPage.this.packageName = ArchiveInfoWizardPage.this.packageNameText.getText();
                }
            }
        });
        GridData destinationTextData = new GridData(1808);
        destinationTextData.horizontalSpan = 3;
        this.destinationComposite = new ArchiveSourceDestinationComposite(ArchivesUIMessages.PackageInfoWizardPage_destination_label, (Composite)infoGroup, this.wizard.getProject().getName(), this.getDescriptorVersion());
        this.destinationComposite.addChangeListener(new ArchiveSourceDestinationComposite.ChangeListener(){

            public void compositeChanged() {
                ArchiveInfoWizardPage.this.validate();
            }
        });
        Group packageTypeGroup = new Group(main, 0);
        packageTypeGroup.setLayout((Layout)new GridLayout(1, false));
        packageTypeGroup.setText(ArchivesUIMessages.PackageInfoWizardPage_packageTypeGroup_label);
        this.expand((Control)packageTypeGroup);
        this.packageExploded = this.archive != null ? this.archive.isExploded() : false;
        this.compressedButton = new Button((Composite)packageTypeGroup, 16);
        this.compressedButton.setText(ArchivesUIMessages.PackageInfoWizardPage_compressedButton_label);
        this.compressedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveInfoWizardPage.this.packageExploded = false;
            }
        });
        this.compressedButton.setSelection(!this.packageExploded);
        this.explodedButton = new Button((Composite)packageTypeGroup, 16);
        this.explodedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArchiveInfoWizardPage.this.packageExploded = true;
            }
        });
        this.explodedButton.setText(ArchivesUIMessages.PackageInfoWizardPage_explodedButton_label);
        this.setControl((Control)main);
        this.fillDefaults();
        this.validate();
    }

    private void fillDefaults() {
        if (this.archive != null) {
            this.compressedButton.setSelection(!this.archive.isExploded());
            this.explodedButton.setSelection(this.archive.isExploded());
            this.packageNameText.setText(this.archive.getName());
            this.packageName = this.archive.getName();
            this.explodedButton.setSelection(this.archive.isExploded());
            this.compressedButton.setSelection(!this.archive.isExploded());
            IArchiveNode parent = this.archive.getParent();
            if (parent != null && !(parent instanceof IArchiveModelRootNode)) {
                this.destinationComposite.init(parent);
            } else {
                this.destinationComposite.init(this.archive.getRawDestinationPath(), this.archive.isDestinationInWorkspace());
            }
        } else if (this.wizard.getInitialNode() != null) {
            this.destinationComposite.init(this.wizard.getInitialNode());
        } else {
            this.destinationComposite.init(this.wizard.getInitialPath(), this.wizard.isInitialPathWorkspaceRelative());
        }
    }

    private boolean validate() {
        String message = null;
        int messageType = 0;
        if (this.packageNameText.getText() == null || this.packageNameText.getText().length() == 0) {
            message = ArchivesUIMessages.PackageInfoWizardPage_error_noPackageName;
            messageType = 4;
        } else if (this.destinationComposite.getMessage() != null) {
            message = this.destinationComposite.getMessage();
            messageType = this.destinationComposite.getStatusType();
        } else if (this.destinationComposite.getDestinationNode() != null) {
            IArchiveNode parentNode = this.destinationComposite.getDestinationNode();
            IArchiveNode[] subPackages = parentNode.getChildren(0);
            int i = 0;
            while (i < subPackages.length) {
                IArchive subPackage = (IArchive)subPackages[i];
                if (subPackage.getName().equals(this.packageNameText.getText()) && !subPackage.equals(this.archive)) {
                    message = NLS.bind((String)ArchivesUIMessages.PackageInfoWizardPage_error_packageAlreadyExists, (Object)this.packageNameText.getText());
                    messageType = 4;
                }
                ++i;
            }
        } else if (this.destinationComposite.getPath() != null) {
            boolean relative = this.destinationComposite.isWorkspaceRelative();
            IPath destinationLocation = PathUtils.getGlobalLocation((String)this.destinationComposite.getPath(), (String)this.wizard.getProject().getName(), (boolean)relative, (double)1.0);
            ArrayList<IArchive> allArchives = new ArrayList<IArchive>();
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                allArchives.addAll(Arrays.asList(ModelUtil.getProjectArchives((IPath)projects[i].getLocation())));
                ++i;
            }
            IArchive[] packages = allArchives.toArray(new IArchive[allArchives.size()]);
            if (packages != null) {
                int i2 = 0;
                while (i2 < packages.length) {
                    IArchive pkg = packages[i2];
                    if (pkg.getName().equals(this.packageNameText.getText()) && PathUtils.getGlobalLocation((IArchiveNode)pkg) != null && PathUtils.getGlobalLocation((IArchiveNode)pkg).equals((Object)destinationLocation) && !pkg.equals(this.archive)) {
                        message = NLS.bind((String)ArchivesUIMessages.PackageInfoWizardPage_error_packageAlreadyExists, (Object)this.packageNameText.getText());
                        messageType = 4;
                    }
                    ++i2;
                }
            }
        } else {
            message = ArchivesUIMessages.PackageInfoWizardPage_error_noDestination;
        }
        this.setPageComplete(message == null || messageType <= 2);
        this.setMessage(message, messageType);
        return messageType <= 2;
    }

    public void pageExited(int button) {
        if (button == 1 || button == 3) {
            this.createPackage();
        }
    }

    private void createPackage() {
        if (this.archive == null) {
            this.archive = ArchivesCore.getInstance().getNodeFactory().createArchive();
        }
        this.archive.setName(this.getPackageName());
        this.archive.setExploded(this.isPackageExploded());
        if (this.destinationComposite.getPath() != null) {
            this.archive.setInWorkspace(this.destinationComposite.isWorkspaceRelative());
            this.archive.setDestinationPath((IPath)new Path(this.destinationComposite.getPath()));
        }
    }

    private void expand(Control control) {
        control.setLayoutData((Object)new GridData(768));
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean isPackageExploded() {
        return this.packageExploded;
    }

    private void setWizard(AbstractArchiveWizard wizard) {
        this.wizard = wizard;
    }

    public IArchive getArchive() {
        return this.archive;
    }

    protected double getDescriptorVersion() {
        IPath loc = this.wizard.getProject().getLocation();
        if (ArchivesModel.instance().isProjectRegistered(loc)) {
            return ArchivesModel.instance().getRoot(loc).getDescriptorVersion();
        }
        return 1.3;
    }

    public String getDestinationPath() {
        return this.destinationComposite.getPath();
    }

    public IArchiveNode getDestinationNode() {
        return this.destinationComposite.getDestinationNode();
    }

    public boolean isDestinationWorkspaceRelative() {
        return this.destinationComposite.isWorkspaceRelative();
    }
}

