/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.model.other.internal.WorkspacePreferenceManager;
import org.jboss.ide.eclipse.archives.ui.ArchivesSharedImages;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.util.composites.ArchiveFilesetDestinationComposite;
import org.jboss.ide.eclipse.archives.ui.util.composites.ArchiveSourceDestinationComposite;
import org.jboss.ide.eclipse.archives.ui.util.composites.FilesetPreviewComposite;

public class FilesetInfoWizardPage
extends WizardPage {
    private IArchiveNode parentNode;
    private IArchiveStandardFileSet fileset;
    private String includes;
    private String excludes;
    private String projectName;
    private boolean flattened;
    private FilesetPreviewComposite previewComposite;
    private Composite mainComposite;
    private Label flattenedLabel;
    private ArchiveSourceDestinationComposite srcDestComposite;
    private Button flattenedYes;
    private Button flattenedNo;
    private Text includesText;
    private Text excludesText;
    private ArchiveFilesetDestinationComposite destinationComposite;
    private Composite flattenedEditor;
    private ChangePreviewRunnable changePreviewRunnable;

    public FilesetInfoWizardPage(Shell parent, IArchiveStandardFileSet fileset, IArchiveNode parentNode) {
        super(ArchivesUIMessages.FilesetInfoWizardPage_new_title, ArchivesUIMessages.FilesetInfoWizardPage_new_title, null);
        if (fileset == null) {
            this.setTitle(ArchivesUIMessages.FilesetInfoWizardPage_new_title);
            this.setMessage(ArchivesUIMessages.FilesetInfoWizardPage_new_message);
        } else {
            this.setTitle(ArchivesUIMessages.FilesetInfoWizardPage_edit_title);
            this.setMessage(ArchivesUIMessages.FilesetInfoWizardPage_edit_message);
        }
        this.fileset = fileset;
        this.parentNode = parentNode;
        this.projectName = parentNode.getProjectName();
    }

    public void createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Group info = this.createInfoGroup(this.mainComposite);
        this.createPreviewGroup(this.mainComposite, info);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (!FilesetInfoWizardPage.this.mainComposite.isDisposed()) {
                    FilesetInfoWizardPage.this.fillDefaults();
                    FilesetInfoWizardPage.this.addListeners();
                    FilesetInfoWizardPage.this.changePreview();
                    FilesetInfoWizardPage.this.includesText.setFocus();
                }
            }
        });
        this.setControl((Control)this.mainComposite);
    }

    private Group createPreviewGroup(Composite mainComposite, Group info) {
        Group previewGroup = new Group(mainComposite, 0);
        previewGroup.setLayoutData((Object)new GridData(1808));
        previewGroup.setLayout((Layout)new GridLayout());
        this.previewComposite = new FilesetPreviewComposite((Composite)previewGroup, 0);
        this.previewComposite.setLayoutData(new GridData(1808));
        previewGroup.setText(ArchivesUIMessages.FilesetInfoWizardPage_previewGroup_label);
        return previewGroup;
    }

    private Group createInfoGroup(Composite mainComposite) {
        Group infoGroup = new Group(mainComposite, 0);
        infoGroup.setText(ArchivesUIMessages.FilesetInfoWizardPage_infoGroup_title);
        infoGroup.setLayout((Layout)new GridLayout(3, false));
        infoGroup.setLayoutData((Object)new GridData(768));
        this.destinationComposite = new ArchiveFilesetDestinationComposite((Composite)infoGroup, 0, this.parentNode);
        this.srcDestComposite = new ArchiveSourceDestinationComposite(ArchivesUIMessages.FilesetInfoWizardPage_rootDirectory_label, (Composite)infoGroup, this.projectName, this.getDescriptorVersion());
        this.flattenedLabel = new Label((Composite)infoGroup, 0);
        this.flattenedLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        new Label((Composite)infoGroup, 0);
        this.flattenedEditor = new Composite((Composite)infoGroup, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 0;
        fillLayout.marginWidth = 0;
        this.flattenedEditor.setLayout((Layout)fillLayout);
        this.flattenedYes = new Button(this.flattenedEditor, 16);
        this.flattenedNo = new Button(this.flattenedEditor, 16);
        Label includesTextLabel = new Label((Composite)infoGroup, 0);
        includesTextLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label includesImage = new Label((Composite)infoGroup, 0);
        this.includesText = new Text((Composite)infoGroup, 2048);
        this.includesText.setLayoutData((Object)new GridData(768));
        Label excludesTextLabel = new Label((Composite)infoGroup, 0);
        excludesTextLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label excludesImage = new Label((Composite)infoGroup, 0);
        this.excludesText = new Text((Composite)infoGroup, 2048);
        this.excludesText.setLayoutData((Object)new GridData(768));
        includesImage.setImage(ArchivesSharedImages.getImage("icons/includes.gif"));
        includesTextLabel.setText(ArchivesUIMessages.FilesetInfoWizardPage_includes_label);
        excludesImage.setImage(ArchivesSharedImages.getImage("icons/excludes.gif"));
        excludesTextLabel.setText(ArchivesUIMessages.FilesetInfoWizardPage_excludes_label);
        this.flattenedLabel.setText(ArchivesUIMessages.Flatten);
        this.flattenedYes.setText(ArchivesUIMessages.Yes);
        this.flattenedNo.setText(ArchivesUIMessages.No);
        return infoGroup;
    }

    private void addListeners() {
        this.includesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesetInfoWizardPage.this.includes = FilesetInfoWizardPage.this.includesText.getText();
                FilesetInfoWizardPage.this.changePreview();
            }
        });
        this.excludesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilesetInfoWizardPage.this.excludes = FilesetInfoWizardPage.this.excludesText.getText();
                FilesetInfoWizardPage.this.changePreview();
            }
        });
        SelectionAdapter flattenAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilesetInfoWizardPage.this.flattened = FilesetInfoWizardPage.this.flattenedYes.getSelection();
                FilesetInfoWizardPage.this.changePreview();
            }
        };
        this.flattenedYes.addSelectionListener((SelectionListener)flattenAdapter);
        this.flattenedNo.addSelectionListener((SelectionListener)flattenAdapter);
        this.srcDestComposite.addChangeListener(new ArchiveSourceDestinationComposite.ChangeListener(){

            public void compositeChanged() {
                FilesetInfoWizardPage.this.validate();
                FilesetInfoWizardPage.this.changePreview();
            }
        });
    }

    private boolean validate() {
        String message = this.srcDestComposite.getMessage();
        int messageType = this.srcDestComposite.getStatusType();
        this.setMessage(message, messageType);
        this.setPageComplete(messageType <= 2);
        return messageType <= 2;
    }

    public IArchiveNode getRootNode() {
        return (IArchiveNode)this.destinationComposite.getPackageNodeDestination();
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean isFlattened() {
        return this.flattened;
    }

    public boolean isRootDirWorkspaceRelative() {
        return this.srcDestComposite.isWorkspaceRelative();
    }

    public String getRawPath() {
        return this.srcDestComposite.getPath();
    }

    public String replaceVariables() {
        try {
            return ArchivesCore.getInstance().getVFS().performStringSubstitution(this.srcDestComposite.getPath(), this.projectName, true);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void fillDefaults() {
        if (this.mainComposite.isDisposed()) {
            return;
        }
        if (this.fileset != null) {
            this.flattened = this.fileset.isFlattened();
            this.flattenedYes.setSelection(this.flattened);
            this.flattenedNo.setSelection(!this.flattened);
            if (this.fileset.getIncludesPattern() != null) {
                this.includes = this.fileset.getIncludesPattern();
                this.includesText.setText(this.includes);
            }
            if (this.fileset.getExcludesPattern() != null) {
                this.excludes = this.fileset.getExcludesPattern();
                this.excludesText.setText(this.excludes);
            }
            if (this.fileset.getRawSourcePath() != null) {
                this.srcDestComposite.init(this.fileset.getRawSourcePath(), this.fileset.isInWorkspace());
            }
        } else {
            String rawPath = "";
            this.srcDestComposite.init(rawPath, true);
            this.flattened = false;
            this.flattenedYes.setSelection(this.flattened);
            this.flattenedNo.setSelection(!this.flattened);
            this.includes = "**";
            this.includesText.setText(this.includes);
            boolean useDefaultExcludes = PrefsInitializer.getBoolean("useDefaultExcludes");
            if (useDefaultExcludes && this.parentNode != null) {
                this.excludesText.setText(PrefsInitializer.getString("defaultExcludesList", (IAdaptable)WorkspacePreferenceManager.getResource((IPath)this.parentNode.getProjectPath()), true));
            }
        }
    }

    private void changePreview() {
        if (this.changePreviewRunnable != null) {
            this.changePreviewRunnable.stop = true;
        }
        this.changePreviewRunnable = new ChangePreviewRunnable();
        Thread t = new Thread(this.changePreviewRunnable);
        t.start();
    }

    protected double getDescriptorVersion() {
        return this.parentNode.getModelRootNode().getDescriptorVersion();
    }

    protected class ChangePreviewRunnable
    implements Runnable {
        public boolean stop = false;

        protected ChangePreviewRunnable() {
        }

        public void run() {
            Runnable r;
            DirectoryScannerFactory.DirectoryScannerExtension ds = null;
            try {
                String effectiveExcludes = FilesetInfoWizardPage.this.excludes;
                if (FilesetInfoWizardPage.this.parentNode.getRootArchive().isDestinationInWorkspace()) {
                    effectiveExcludes = String.valueOf(effectiveExcludes) + "," + FilesetInfoWizardPage.this.parentNode.getRootArchive().getRawDestinationPath();
                }
                IPath parentRelativeToRoot = FilesetInfoWizardPage.this.parentNode.getRootArchiveRelativePath();
                ds = DirectoryScannerFactory.createDirectoryScanner((String)FilesetInfoWizardPage.this.replaceVariables(), (IPath)parentRelativeToRoot, (String)FilesetInfoWizardPage.this.includes, (String)effectiveExcludes, (String)FilesetInfoWizardPage.this.parentNode.getProjectName(), (boolean)FilesetInfoWizardPage.this.srcDestComposite.isWorkspaceRelative(), (double)FilesetInfoWizardPage.this.parentNode.getModelRootNode().getDescriptorVersion(), (boolean)false);
                Iterator it = null;
                try {
                    it = ds.iterator();
                }
                catch (IllegalStateException ise) {
                    it = new ArrayList().iterator();
                }
                ArrayList<String> paths2 = new ArrayList<String>();
                while (it.hasNext() && paths2.size() < 30) {
                    DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper fw = (DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper)it.next();
                    paths2.add(fw.getFilesetRelative());
                }
                final ArrayList<Path> list = new ArrayList<Path>();
                int i = 0;
                while (i < paths2.size()) {
                    Path filesetRelative = FilesetInfoWizardPage.this.flattened ? new Path(new Path((String)paths2.get(i)).lastSegment()) : new Path((String)paths2.get(i));
                    if (!list.contains(filesetRelative)) {
                        list.add(filesetRelative);
                    }
                    ++i;
                }
                r = new Runnable(){

                    public void run() {
                        FilesetInfoWizardPage.this.previewComposite.setInput(list.toArray());
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
                r = new Runnable(){

                    public void run() {
                        FilesetInfoWizardPage.this.previewComposite.setInput(new IPath[0]);
                    }
                };
            }
            if (!this.stop) {
                Display.getDefault().asyncExec(r);
            }
        }
    }
}

