/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.jboss.tools.common.jdt.debug.RemoteDebugActivator;
import org.jboss.tools.common.jdt.debug.ui.RemoteDebugUIActivator;
import org.jboss.tools.jmx.core.IDebuggableConnection;
import org.jboss.tools.jmx.ui.JMXUIActivator;

public class ConnectDebuggerAction
extends Action {
    private IDebuggableConnection con;

    public ConnectDebuggerAction(IDebuggableConnection wrapper) {
        this.con = wrapper;
        this.setImageDescriptor(JMXUIActivator.getDefault().getSharedImages().descriptor("icons/full/obj16/debug_view.gif"));
        this.setEnabled(!this.isDebuggerConnected(wrapper));
        this.setText("Connect Debugger");
    }

    private boolean isDebuggerConnected(IDebuggableConnection wrapper) {
        return RemoteDebugActivator.isRemoteDebuggerConnected((String)wrapper.getDebugHost(), (int)wrapper.getDebugPort());
    }

    public void run() {
        String mainClass = this.con.getMainClass();
        if (mainClass != null) {
            IJavaProject jp = this.findProjectForMain(mainClass);
            try {
                ArrayList<IJavaProject> javaProjects = new ArrayList<IJavaProject>();
                IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < all.length) {
                    IProject currentProject = all[i];
                    if ((jp == null || !currentProject.equals((Object)jp.getProject())) && currentProject.isAccessible() && currentProject.hasNature("org.eclipse.jdt.core.javanature")) {
                        javaProjects.add(JavaCore.create((IProject)currentProject));
                    }
                    ++i;
                }
                ILaunchConfiguration config = RemoteDebugActivator.createOrGetDefaultLaunchConfiguration((String)Integer.toString(this.con.getDebugPort()), (String)this.con.getDebugHost(), (IJavaProject)jp, (IJavaElement[])javaProjects.toArray(new IJavaProject[javaProjects.size()]));
                DebugUITools.launch((ILaunchConfiguration)config, (String)"debug");
            }
            catch (CoreException ce) {
                JMXUIActivator.log(4, ce.getMessage(), ce);
            }
        } else {
            RemoteDebugUIActivator.openLaunchDebuggerDialog();
        }
    }

    private IJavaProject findProjectForMain(String mainClass) {
        IProject[] all = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < all.length) {
            IJavaProject jp = JavaCore.create((IProject)all[i]);
            try {
                IType t = jp.findType(mainClass);
                if (t != null) {
                    return jp;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }
}

