/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.tables;

import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.jmx.core.MBeanInfoWrapper;
import org.jboss.tools.jmx.core.MBeanOperationInfoWrapper;
import org.jboss.tools.jmx.core.util.StringUtils;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.JMXImages;

public class MBeanOperationsTable {
    private TableViewer viewer;

    public MBeanOperationsTable(Composite parent, FormToolkit toolkit) {
        Table operationsTable = toolkit.createTable(parent, 65536);
        GridData gd = new GridData(1808);
        gd.heightHint = 20;
        gd.widthHint = 100;
        operationsTable.setLayoutData((Object)gd);
        toolkit.paintBordersFor(parent);
        this.createColumns(operationsTable);
        operationsTable.setLinesVisible(true);
        operationsTable.setHeaderVisible(true);
        this.viewer = new TableViewer(operationsTable);
        this.viewer.setContentProvider((IContentProvider)new MBeanOpContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MBeanOpLabelProvider());
    }

    private void createColumns(final Table opTable) {
        TableColumn blankCol = new TableColumn(opTable, 0);
        blankCol.setText("");
        blankCol.setWidth(20);
        final TableColumn returnType = new TableColumn(opTable, 0);
        returnType.setText(Messages.returnType);
        returnType.setWidth(100);
        final TableColumn opName = new TableColumn(opTable, 0);
        opName.setText(Messages.name);
        opName.setWidth(150);
        final TableColumn params = new TableColumn(opTable, 0);
        params.setText(Messages.parameters);
        params.setWidth(300);
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                int colIndex;
                TableColumn sortColumn = opTable.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = opTable.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    opTable.setSortColumn(currentColumn);
                    dir = 128;
                }
                if (currentColumn == returnType) {
                    colIndex = 1;
                } else if (currentColumn == opName) {
                    colIndex = 2;
                } else if (currentColumn == params) {
                    colIndex = 3;
                } else {
                    return;
                }
                opTable.setSortDirection(dir);
                MBeanOperationsTable.this.viewer.setSorter((ViewerSorter)new MBeanOpViewerSorter(dir, colIndex));
            }
        };
        returnType.addListener(13, sortListener);
        opName.addListener(13, sortListener);
        params.addListener(13, sortListener);
        opTable.setSortColumn(opName);
        opTable.setSortDirection(128);
    }

    public void setInput(MBeanInfoWrapper input) {
        if (input == null || input.getMBeanInfo() == null) {
            this.viewer.setInput(null);
        } else {
            this.viewer.setInput((Object)input.getMBeanOperationInfoWrappers());
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    protected class MBeanOpContentProvider
    implements IStructuredContentProvider {
        private MBeanOperationInfoWrapper[] opInfos;

        protected MBeanOpContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.opInfos == null) {
                return new Object[0];
            }
            return this.opInfos;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.opInfos = (MBeanOperationInfoWrapper[])newInput;
        }
    }

    protected class MBeanOpLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected MBeanOpLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return JMXImages.get("org.jboss.tools.jmx.ui.methpub_obj.gif");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof MBeanOperationInfoWrapper)) {
                return super.getText(element);
            }
            MBeanOperationInfoWrapper wrapper = (MBeanOperationInfoWrapper)element;
            MBeanOperationInfo opInfo = wrapper.getMBeanOperationInfo();
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    return opInfo.getReturnType() != null ? StringUtils.toString((String)opInfo.getReturnType()) : "void";
                }
                case 2: {
                    return opInfo.getName();
                }
                case 3: {
                    MBeanParameterInfo[] params = opInfo.getSignature();
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < params.length) {
                        String type = params[j].getType();
                        if (j != 0) {
                            sb.append(", ");
                        }
                        sb.append(StringUtils.toString((String)type));
                        ++j;
                    }
                    return sb.toString();
                }
            }
            return this.getText(element);
        }
    }

    protected class MBeanOpViewerSorter
    extends ViewerSorter {
        int fDirection;
        int fIndex;

        protected MBeanOpViewerSorter(int direction, int index) {
            this.fDirection = direction == 128 ? -1 : 1;
            this.fIndex = index;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof MBeanOperationInfo && e2 instanceof MBeanOperationInfo) {
                MBeanOperationInfo opInfo1 = ((MBeanOperationInfoWrapper)e1).getMBeanOperationInfo();
                MBeanOperationInfo opInfo2 = ((MBeanOperationInfoWrapper)e2).getMBeanOperationInfo();
                switch (this.fIndex) {
                    case 1: {
                        String a1 = opInfo1.getReturnType();
                        String a2 = opInfo2.getReturnType();
                        int p = a1.lastIndexOf(46);
                        if (p != -1) {
                            a1 = a1.substring(p + 1);
                        }
                        if ((p = a2.lastIndexOf(46)) != -1) {
                            a2 = a2.substring(p + 1);
                        }
                        return this.fDirection * a1.compareTo(a2);
                    }
                    case 2: {
                        return this.fDirection * opInfo1.getName().compareTo(opInfo2.getName());
                    }
                    case 3: {
                        MBeanParameterInfo[] info1 = opInfo1.getSignature();
                        MBeanParameterInfo[] info2 = opInfo2.getSignature();
                        if (info2.length == 0) {
                            return this.fDirection;
                        }
                        if (info1.length == 0) {
                            return -this.fDirection;
                        }
                        return this.fDirection * info1[0].getType().compareTo(info2[0].getType());
                    }
                }
            }
            return this.fDirection * super.compare(viewer, e1, e2);
        }
    }
}

