/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.ide.eclipse.as.core.server.IPromptHandler;
import org.jboss.ide.eclipse.as.core.server.UserPrompter;
import org.jboss.ide.eclipse.as.wtp.ui.prompt.ServerAlreadyStartedPrompter;
import org.jboss.ide.eclipse.as.wtp.ui.prompt.ServerHotCodeReplacePrompter;
import org.jboss.ide.eclipse.as.wtp.ui.prompt.ZombieProcessPrompter;
import org.jboss.tools.foundation.ui.plugin.BaseUISharedImages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WTPOveridePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.ide.eclipse.as.wtp.ui";
    private static WTPOveridePlugin plugin;
    private BaseUISharedImages sharedImages = null;
    public static final String JMX_IMG = "icons/jmeth_obj.gif";
    public static final String STDOUT_IMG = "icons/stdout.gif";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        UserPrompter.getDefaultPrompter().addPromptHandler(101, (IPromptHandler)new ServerAlreadyStartedPrompter());
        UserPrompter.getDefaultPrompter().addPromptHandler(102, (IPromptHandler)new ZombieProcessPrompter());
        ServerHotCodeReplacePrompter hcrPrompt = new ServerHotCodeReplacePrompter();
        UserPrompter.getDefaultPrompter().addPromptHandler(1013, (IPromptHandler)hcrPrompt);
        UserPrompter.getDefaultPrompter().addPromptHandler(1014, (IPromptHandler)hcrPrompt);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static WTPOveridePlugin getInstance() {
        return plugin;
    }

    public static void log(Exception e) {
        WTPOveridePlugin.log(e.getMessage(), e);
    }

    public static void log(String message, Exception e) {
        Status status = new Status(4, PLUGIN_ID, message, (Throwable)e);
        WTPOveridePlugin.getInstance().getLog().log((IStatus)status);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(String message) {
        return WTPOveridePlugin.createErrorStatus(message, null);
    }

    public static IStatus createWarningStatus(String message) {
        return WTPOveridePlugin.createWarningStatus(message, null);
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, -1, message, exception);
    }

    public static IStatus createWarningStatus(String message, Throwable exception) {
        return new Status(2, PLUGIN_ID, -1, message, exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return WTPOveridePlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return WTPOveridePlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(WTPOveridePlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }

    public BaseUISharedImages getSharedImages() {
        if (this.sharedImages == null) {
            this.sharedImages = this.createSharedImages();
        }
        return this.sharedImages;
    }

    protected BaseUISharedImages createSharedImages() {
        return new ASWTPSharedImages(this.getBundle());
    }

    private static class ASWTPSharedImages
    extends BaseUISharedImages {
        public ASWTPSharedImages(Bundle pluginBundle) {
            super(pluginBundle);
            this.addImage(WTPOveridePlugin.JMX_IMG, WTPOveridePlugin.JMX_IMG);
            this.addImage(WTPOveridePlugin.STDOUT_IMG, WTPOveridePlugin.STDOUT_IMG);
        }
    }
}

