/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.console;

import java.io.IOException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.ide.eclipse.as.core.server.IServerConsoleWriter;
import org.jboss.ide.eclipse.as.wtp.ui.WTPOveridePlugin;

public class ServerConsoleWriter
implements IServerConsoleWriter {
    public static String CONSOLE_TYPE = String.valueOf(ServerConsoleWriter.class.getPackage().getName()) + ".ServerConsole";
    public static String ACTIVATE_ON_WRITE_ATTRIBUTE_NAME = String.valueOf(ServerConsoleWriter.class.getName()) + ".activateOnWrite";

    public void writeToShell(String serverId, String[] lines) {
        this.writeToShell(serverId, lines, ActivateOnWrite.UNDEFINED);
    }

    public void writeToShell(String serverId, String[] lines, boolean activateOnWrite) {
        this.writeToShell(serverId, lines, ActivateOnWrite.valueOf(activateOnWrite));
    }

    private void writeToShell(String serverId, String[] lines, ActivateOnWrite activateOnWrite) {
        MessageConsole myConsole = ServerConsoleWriter.findConsole(serverId);
        boolean activateOnWriteFlag = (Boolean)(activateOnWrite == ActivateOnWrite.UNDEFINED ? myConsole.getAttribute(ACTIVATE_ON_WRITE_ATTRIBUTE_NAME) : Boolean.valueOf(activateOnWrite.getValue()));
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (MessageConsoleStream out = myConsole.newMessageStream();){
                out.setActivateOnWrite(activateOnWriteFlag);
                int i = 0;
                while (i < lines.length) {
                    out.println(lines[i]);
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            WTPOveridePlugin.logError(e);
        }
    }

    private static synchronized MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, CONSOLE_TYPE, null, true);
        myConsole.setAttribute(ACTIVATE_ON_WRITE_ATTRIBUTE_NAME, (Object)true);
        conMan.addConsoles(new IConsole[]{myConsole});
        conMan.showConsoleView((IConsole)myConsole);
        return myConsole;
    }

    private static enum ActivateOnWrite {
        TRUE(true),
        FALSE(false),
        UNDEFINED(false);

        private boolean value;

        private ActivateOnWrite(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }

        public static ActivateOnWrite valueOf(String string) {
            return Enum.valueOf(ActivateOnWrite.class, string);
        }
    }
}

