/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.eclipse.jdt.ui.ProjectExplorer;
import org.jboss.reddeer.eclipse.jdt.ui.ide.NewJavaProjectWizardDialog;
import org.jboss.reddeer.eclipse.jdt.ui.ide.NewJavaProjectWizardPage;
import org.jboss.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.jboss.reddeer.eclipse.ui.views.log.LogView;
import org.jboss.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.jboss.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.workbench.impl.shell.WorkbenchShell;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesView;
import org.junit.Assert;
import org.junit.BeforeClass;

@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
@CleanWorkspaceRequirement.CleanWorkspace
public class ArchivesTestBase {
    protected static ProjectExplorer projectExplorer = new ProjectExplorer();
    protected static ProjectArchivesView view = new ProjectArchivesView();
    protected static final Logger log = Logger.getLogger(ArchivesTestBase.class);

    @BeforeClass
    public static void maximizeWorkbench() {
        new WorkbenchShell().maximize();
    }

    protected ProjectArchivesView openProjectArchivesView() {
        view.open();
        return view;
    }

    protected static ProjectArchivesView viewForProject(String projectName) {
        view.open();
        projectExplorer.open();
        projectExplorer.getProject(projectName).select();
        view.open();
        return view;
    }

    protected ProjectArchivesExplorer explorerForProject(String projectName) {
        return new ProjectArchivesExplorer(projectName);
    }

    protected void assertArchiveIsInView(String project, ProjectArchivesView view, String archiveName) {
        view.open();
        Assert.assertTrue((boolean)view.getProject(project).hasArchive(archiveName));
    }

    protected void assertArchiveIsNotInView(String project, ProjectArchivesView view, String archiveName) {
        view.open();
        Assert.assertFalse((boolean)view.getProject(project).hasArchive(archiveName));
    }

    protected void assertArchiveIsInExplorer(ProjectArchivesExplorer explorer, String archiveName) {
        try {
            explorer.getArchive(archiveName);
        }
        catch (Exception sle) {
            Assert.fail((String)("'" + archiveName + "' is not in archives explorer but it should!"));
        }
    }

    protected void assertArchiveIsNotInExplorer(ProjectArchivesExplorer explorer, String archiveName) {
        try {
            explorer.getArchive(archiveName);
            Assert.fail((String)("'" + archiveName + "' is in archives explorer but it should not!"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void deleteErrorView() {
        LogView lw = new LogView();
        lw.open();
        lw.deleteLog();
    }

    protected static void createJavaProject(String projectName) {
        NewJavaProjectWizardDialog javaProject = new NewJavaProjectWizardDialog();
        javaProject.open();
        NewJavaProjectWizardPage javaWizardPage = new NewJavaProjectWizardPage();
        javaWizardPage.setProjectName(projectName);
        javaProject.finish(false);
    }

    protected static void addArchivesSupport(String projectName) {
        ArchivesTestBase.addRemoveArchivesSupport(projectName, true);
    }

    protected static void removeArchivesSupport(String projectName) {
        ArchivesTestBase.addRemoveArchivesSupport(projectName, false);
    }

    private static void addRemoveArchivesSupport(String projectName, boolean add) {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.getProject(projectName).select();
        if (add) {
            new ContextMenu(new String[]{"Configure", "Add Project Archives Support"}).select();
        } else {
            new ContextMenu(new String[]{"Configure", "Remove Project Archives Support"}).select();
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
    }

    protected static void createArchive(NewJarDialog dialog, String archiveName, boolean standardCompression) {
        dialog.setArchiveName(archiveName);
        if (standardCompression) {
            dialog.setZipStandardArchiveType();
        } else {
            dialog.setNoCompressionArchiveType();
        }
        dialog.finish();
    }

    protected static void createArchive(String project, String archiveName, boolean standardCompression) {
        view = ArchivesTestBase.viewForProject(project);
        NewJarDialog dialog = view.getProject(project).newJarArchive();
        dialog.setArchiveName(archiveName);
        if (standardCompression) {
            dialog.setZipStandardArchiveType();
        } else {
            dialog.setNoCompressionArchiveType();
        }
        dialog.finish();
    }
}

