/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.junit.BeforeClass;
import org.junit.Test;

public class CreatingArchiveTest
extends ArchivesTestBase {
    private static String projectName = "CreatingArchiveTest";
    private final String ARCHIVE_STANDARD_1 = String.valueOf(projectName) + "-standard.jar";
    private final String ARCHIVE_STANDARD_2 = String.valueOf(projectName) + "-standard-expl.jar";
    private final String ARCHIVE_NO_COMPRESSION_1 = String.valueOf(projectName) + "-nocompression.jar";
    private final String ARCHIVE_NO_COMPRESSION_2 = String.valueOf(projectName) + "-nocompression-expl.jar";
    private final String PATH_SUFFIX = " [/" + projectName + "]";
    private final String ARCHIVE_STANDARD_1_PATH = String.valueOf(this.ARCHIVE_STANDARD_1) + this.PATH_SUFFIX;
    private final String ARCHIVE_STANDARD_2_PATH = String.valueOf(this.ARCHIVE_STANDARD_2) + this.PATH_SUFFIX;
    private final String ARCHIVE_NO_COMPRESSION_1_PATH = String.valueOf(this.ARCHIVE_NO_COMPRESSION_1) + this.PATH_SUFFIX;
    private final String ARCHIVE_NO_COMPRESSION_2_PATH = String.valueOf(this.ARCHIVE_NO_COMPRESSION_2) + this.PATH_SUFFIX;

    @BeforeClass
    public static void setup() {
        CreatingArchiveTest.createJavaProject(projectName);
        CreatingArchiveTest.addArchivesSupport(projectName);
    }

    @Test
    public void testCreatingArchiveWithView() {
        view = CreatingArchiveTest.viewForProject(projectName);
        NewJarDialog dialog = view.getProject(projectName).newJarArchive();
        CreatingArchiveTest.createArchive(dialog, this.ARCHIVE_STANDARD_1, true);
        this.assertArchiveIsInView(projectName, view, this.ARCHIVE_STANDARD_1_PATH);
        dialog = view.getProject(projectName).newJarArchive();
        CreatingArchiveTest.createArchive(dialog, this.ARCHIVE_NO_COMPRESSION_1, false);
        this.assertArchiveIsInView(projectName, view, this.ARCHIVE_NO_COMPRESSION_1_PATH);
    }

    @Test
    public void testCreatingArchiveWithExplorer() {
        ProjectArchivesExplorer explorer = this.explorerForProject(projectName);
        NewJarDialog dialog = explorer.newJarArchive();
        CreatingArchiveTest.createArchive(dialog, this.ARCHIVE_STANDARD_2, true);
        this.assertArchiveIsInExplorer(explorer, this.ARCHIVE_STANDARD_2_PATH);
        dialog = explorer.newJarArchive();
        CreatingArchiveTest.createArchive(dialog, this.ARCHIVE_NO_COMPRESSION_2, false);
        this.assertArchiveIsInExplorer(explorer, this.ARCHIVE_NO_COMPRESSION_2_PATH);
    }
}

