/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeletingArchiveTest
extends ArchivesTestBase {
    private static String projectName = "DeletingArchiveTest";
    private static final String ARCHIVE_NAME_AA = String.valueOf(projectName) + "aa.jar";
    private static final String ARCHIVE_NAME_AB = String.valueOf(projectName) + "ab.jar";
    private static final String ARCHIVE_NAME_BA = String.valueOf(projectName) + "ba.jar";
    private static final String ARCHIVE_NAME_BB = String.valueOf(projectName) + "bb.jar";
    private static final String ARCHIVE_NAME_CA = String.valueOf(projectName) + "ca.jar";
    private static final String ARCHIVE_NAME_CB = String.valueOf(projectName) + "cb.jar";
    private static final String ARCHIVE_NAME_DA = String.valueOf(projectName) + "da.jar";
    private static final String ARCHIVE_NAME_DB = String.valueOf(projectName) + "db.jar";
    private static final String PATH_SUFFIX = " [/" + projectName + "]";

    @BeforeClass
    public static void setup() {
        DeletingArchiveTest.createJavaProject(projectName);
        DeletingArchiveTest.addArchivesSupport(projectName);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_AA, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_AB, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_BA, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_BB, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_CA, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_CB, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_DA, true);
        DeletingArchiveTest.createArchive(projectName, ARCHIVE_NAME_DB, true);
    }

    @Test
    public void testDeletingArchiveWithView() {
        view = DeletingArchiveTest.viewForProject(projectName);
        view.getProject(projectName).getArchive(String.valueOf(ARCHIVE_NAME_AA) + PATH_SUFFIX).deleteArchive(true);
        this.assertArchiveIsNotInView(projectName, view, String.valueOf(ARCHIVE_NAME_AA) + PATH_SUFFIX);
    }

    @Test
    public void testDeletingArchiveWithExplorer() {
        ProjectArchivesExplorer explorer = this.explorerForProject(projectName);
        explorer.getArchive(String.valueOf(ARCHIVE_NAME_BA) + PATH_SUFFIX).deleteArchive(true);
        this.assertArchiveIsNotInExplorer(explorer, String.valueOf(ARCHIVE_NAME_BA) + PATH_SUFFIX);
    }
}

