/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.swt.api.Tree;
import org.jboss.reddeer.swt.condition.TreeContainsItem;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.component.Archive;
import org.junit.BeforeClass;
import org.junit.Test;

public class FilesetTest
extends ArchivesTestBase {
    private static final String PROJECT_1 = "FilesetTest1";
    private static final String PROJECT_2 = "FilesetTest2";
    private static final String PROJECT_1_ARCHIVE = "FilesetTest1.jar";
    private static final String PROJECT_1_ARCHIVE_PATH = "FilesetTest1.jar [/FilesetTest1]";
    private static final String PROJECT_2_ARCHIVE = "FilesetTest2.jar";
    private static final String PROJECT_2_ARCHIVE_PATH = "FilesetTest2.jar [/FilesetTest2]";
    private static final String INCLUDES_1 = ".project";
    private static final String EXCLUDES_1 = "*.jar";
    private static final String INCLUDES_2 = "**";
    private static final String EXCLUDES_2 = "*jar";
    private static final String INCLUDES_NEW = ".classpath";

    @BeforeClass
    public static void setup() {
        FilesetTest.createJavaProject(PROJECT_1);
        FilesetTest.addArchivesSupport(PROJECT_1);
        FilesetTest.createArchive(PROJECT_1, PROJECT_1_ARCHIVE, true);
        FilesetTest.createJavaProject(PROJECT_2);
        FilesetTest.addArchivesSupport(PROJECT_2);
        FilesetTest.createArchive(PROJECT_2, PROJECT_2_ARCHIVE, true);
    }

    @Test
    public void testCreatingFileset() {
        view = FilesetTest.viewForProject(PROJECT_1);
        Archive archiveInView = view.getProject(PROJECT_1).getArchive(PROJECT_1_ARCHIVE_PATH);
        archiveInView.newFileset().setIncludes(INCLUDES_1).setExcludes(EXCLUDES_2).setFlatten(true).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_1, PROJECT_1_ARCHIVE_PATH, this.formatFileset(PROJECT_1, INCLUDES_1, EXCLUDES_2)}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_1);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_1_ARCHIVE_PATH);
        archiveInExplorer.newFileset().setIncludes(INCLUDES_2).setExcludes(EXCLUDES_2).setFlatten(true).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_1, "Project Archives", PROJECT_1_ARCHIVE_PATH, this.formatFileset(PROJECT_1, INCLUDES_2, EXCLUDES_2)}));
    }

    @Test
    public void testModifyingFileset() {
        view = FilesetTest.viewForProject(PROJECT_2);
        Archive archiveInView = view.getProject(PROJECT_2).getArchive(PROJECT_2_ARCHIVE_PATH);
        this.createFileset(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, INCLUDES_1, EXCLUDES_1);
        this.createFileset(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, INCLUDES_2, EXCLUDES_2);
        String fileset = this.formatFileset(PROJECT_2, INCLUDES_1, EXCLUDES_1);
        String newFileset = this.formatFileset(PROJECT_2, INCLUDES_NEW, EXCLUDES_1);
        archiveInView.getFileset(fileset, false).editFileset().setIncludes(INCLUDES_NEW).setExcludes(EXCLUDES_1).finish();
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, PROJECT_2_ARCHIVE_PATH, fileset}));
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, PROJECT_2_ARCHIVE_PATH, newFileset}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_2);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_2_ARCHIVE_PATH);
        fileset = this.formatFileset(PROJECT_2, INCLUDES_2, EXCLUDES_2);
        newFileset = this.formatFileset(PROJECT_2, INCLUDES_NEW, EXCLUDES_2);
        archiveInExplorer.getFileset(fileset, true).editFileset().setIncludes(INCLUDES_NEW).setExcludes(EXCLUDES_2).finish();
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, "Project Archives", PROJECT_2_ARCHIVE_PATH, fileset}));
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, "Project Archives", PROJECT_2_ARCHIVE_PATH, newFileset}));
    }

    @Test
    public void testDeletingFileset() {
        view = FilesetTest.viewForProject(PROJECT_2);
        Archive archiveInView = view.getProject(PROJECT_2).getArchive(PROJECT_2_ARCHIVE_PATH);
        this.createFileset(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, INCLUDES_1, EXCLUDES_1);
        this.createFileset(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, INCLUDES_2, EXCLUDES_2);
        archiveInView.getFileset(this.formatFileset(PROJECT_2, INCLUDES_1, EXCLUDES_1), false).deleteFileset(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, PROJECT_2_ARCHIVE_PATH, this.formatFileset(PROJECT_2, INCLUDES_1, EXCLUDES_1)}), TimePeriod.LONG);
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_2);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_2_ARCHIVE_PATH);
        archiveInExplorer.getFileset(this.formatFileset(PROJECT_2, INCLUDES_2, EXCLUDES_2), true).deleteFileset(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, "Project Archives", PROJECT_2_ARCHIVE_PATH, this.formatFileset(PROJECT_2, INCLUDES_2, EXCLUDES_2)}), TimePeriod.LONG);
    }

    private String formatFileset(String projectName, String includes, String excludes) {
        return "+[" + includes + "] -[" + excludes + "] : /" + projectName;
    }

    private void createFileset(Archive archiveInView, String project, String archivePath, String inclues, String excludes) {
        archiveInView.newFileset().setIncludes(inclues).setExcludes(excludes).setFlatten(true).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, archivePath, this.formatFileset(project, inclues, excludes)}));
    }
}

