/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.swt.api.Tree;
import org.jboss.reddeer.swt.condition.TreeContainsItem;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.tools.archives.reddeer.archives.ui.EditArchiveDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.junit.BeforeClass;
import org.junit.Test;

public class ModifyingArchiveTest
extends ArchivesTestBase {
    private static String project = "pr3";
    private static final String ARCHIVE_NAME_1 = String.valueOf(project) + "a.jar";
    private static final String ARCHIVE_NAME_2 = String.valueOf(project) + "b.jar";
    private static final String ARCHIVE_NAME_1_NEW = String.valueOf(project) + "a-new.jar";
    private static final String ARCHIVE_NAME_2_NEW = String.valueOf(project) + "b-new.jar";
    private static final String PATH_SUFFIX = " [/" + project + "]";
    private static final String PATH_ARCHIVE_1 = String.valueOf(ARCHIVE_NAME_1) + PATH_SUFFIX;
    private static final String PATH_ARCHIVE_2 = String.valueOf(ARCHIVE_NAME_2) + PATH_SUFFIX;
    private static final String PATH_ARCHIVE_1_NEW = String.valueOf(ARCHIVE_NAME_1_NEW) + PATH_SUFFIX;
    private static final String PATH_ARCHIVE_2_NEW = String.valueOf(ARCHIVE_NAME_2_NEW) + PATH_SUFFIX;

    @BeforeClass
    public static void setup() {
        ModifyingArchiveTest.createJavaProject(project);
        ModifyingArchiveTest.addArchivesSupport(project);
        ModifyingArchiveTest.createArchive(project, ARCHIVE_NAME_1, true);
        ModifyingArchiveTest.createArchive(project, ARCHIVE_NAME_2, true);
    }

    @Test
    public void testModifyingArchiveWithView() {
        view = ModifyingArchiveTest.viewForProject(project);
        EditArchiveDialog dialog = view.getProject(project).getArchive(PATH_ARCHIVE_1).editArchive();
        this.editArchive(dialog, ARCHIVE_NAME_1_NEW);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, PATH_ARCHIVE_1}));
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, PATH_ARCHIVE_1_NEW}));
    }

    @Test
    public void testModifyingArchiveWithExplorer() {
        ProjectArchivesExplorer explorer = new ProjectArchivesExplorer(project);
        EditArchiveDialog dialog = explorer.getArchive(PATH_ARCHIVE_2).editArchive();
        this.editArchive(dialog, ARCHIVE_NAME_2_NEW);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, "Project Archives", PATH_ARCHIVE_2}));
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, "Project Archives", PATH_ARCHIVE_2_NEW}));
    }

    private void editArchive(EditArchiveDialog dialog, String newArchiveName) {
        dialog.setArchiveName(newArchiveName);
        dialog.finish();
    }
}

