/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.hamcrest.Matcher;
import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.eclipse.condition.ProjectContainsProjectItem;
import org.jboss.reddeer.eclipse.jdt.ui.ProjectExplorer;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.api.Tree;
import org.jboss.reddeer.swt.condition.ShellIsAvailable;
import org.jboss.reddeer.swt.condition.TreeContainsItem;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.text.DefaultText;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.component.Archive;
import org.junit.BeforeClass;
import org.junit.Test;

public class UserLibrariesFilesetTest
extends ArchivesTestBase {
    private static String PROJECT_NAME1 = "UserLibrariesFilesetTest1";
    private static String ARCHIVE_NAME1 = String.valueOf(PROJECT_NAME1) + ".jar";
    private static String ARCHIVE_PATH1 = String.valueOf(ARCHIVE_NAME1) + " [/" + PROJECT_NAME1 + "]";
    private static String PROJECT_NAME2 = "UserLibrariesFilesetTest2";
    private static String ARCHIVE_NAME2 = String.valueOf(PROJECT_NAME2) + ".jar";
    private static String ARCHIVE_PATH2 = String.valueOf(ARCHIVE_NAME2) + " [/" + PROJECT_NAME2 + "]";
    private static String PROJECT_NAME3 = "UserLibrariesFilesetTest3";
    private static String ARCHIVE_NAME3 = String.valueOf(PROJECT_NAME3) + ".jar";
    private static String ARCHIVE_PATH3 = String.valueOf(ARCHIVE_NAME3) + " [/" + PROJECT_NAME3 + "]";
    private static final String USER_LIBRARY_1 = "myLibrary1";
    private static final String USER_LIBRARY_2 = "myLibrary2";
    private static final String USER_LIBRARY_3 = "myLibrary3";
    private static final String USER_LIBRARY_4 = "myLibrary4";

    @BeforeClass
    public static void setup() {
        UserLibrariesFilesetTest.createUserLibrary(USER_LIBRARY_1);
        UserLibrariesFilesetTest.createUserLibrary(USER_LIBRARY_2);
        UserLibrariesFilesetTest.createUserLibrary(USER_LIBRARY_3);
        UserLibrariesFilesetTest.createUserLibrary(USER_LIBRARY_4);
    }

    @BeforeClass
    public static void prepareWorkspace() {
        UserLibrariesFilesetTest.createJavaProject(PROJECT_NAME1);
        UserLibrariesFilesetTest.addArchivesSupport(PROJECT_NAME1);
        UserLibrariesFilesetTest.createArchive(PROJECT_NAME1, ARCHIVE_NAME1, true);
        UserLibrariesFilesetTest.createJavaProject(PROJECT_NAME2);
        UserLibrariesFilesetTest.addArchivesSupport(PROJECT_NAME2);
        UserLibrariesFilesetTest.createArchive(PROJECT_NAME2, ARCHIVE_NAME2, true);
        UserLibrariesFilesetTest.createJavaProject(PROJECT_NAME3);
        UserLibrariesFilesetTest.addArchivesSupport(PROJECT_NAME3);
        UserLibrariesFilesetTest.createArchive(PROJECT_NAME3, ARCHIVE_NAME3, true);
    }

    @Test
    public void testCreatingUserLibraryFileset() {
        view = UserLibrariesFilesetTest.viewForProject(PROJECT_NAME1);
        Archive archiveInView = view.getProject(PROJECT_NAME1).getArchive(ARCHIVE_PATH1);
        archiveInView.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_1).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME1, ARCHIVE_PATH1, USER_LIBRARY_1}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_NAME1);
        Archive archiveInExplorer = explorer.getArchive(ARCHIVE_PATH1);
        archiveInExplorer.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_2).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME1, "Project Archives", ARCHIVE_PATH1, USER_LIBRARY_2}));
    }

    @Test
    public void testModifyingUserLibraryFileset() {
        view = UserLibrariesFilesetTest.viewForProject(PROJECT_NAME2);
        Archive archiveInView = view.getProject(PROJECT_NAME2).getArchive(ARCHIVE_PATH2);
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_NAME2);
        Archive archiveInExplorer = explorer.getArchive(ARCHIVE_PATH2);
        archiveInExplorer.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_2).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME2, "Project Archives", ARCHIVE_PATH2, USER_LIBRARY_2}));
        archiveInView.getUserLibraryFileset(USER_LIBRARY_2, true).editUserLibraryFileset().selectUserLibrary(USER_LIBRARY_4).finish();
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        new WaitWhile((WaitCondition)new ProjectContainsProjectItem(pe.getProject(PROJECT_NAME2), new String[]{"Project Archives", ARCHIVE_PATH2, USER_LIBRARY_2}));
        new WaitUntil((WaitCondition)new ProjectContainsProjectItem(pe.getProject(PROJECT_NAME2), new String[]{"Project Archives", ARCHIVE_PATH2, USER_LIBRARY_4}));
        archiveInView.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_1).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME2, ARCHIVE_PATH2, USER_LIBRARY_1}));
        archiveInView.getUserLibraryFileset(USER_LIBRARY_1, false).editUserLibraryFileset().selectUserLibrary(USER_LIBRARY_3).finish();
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME2, ARCHIVE_PATH2, USER_LIBRARY_1}));
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME2, ARCHIVE_PATH2, USER_LIBRARY_3}));
    }

    @Test
    public void testDeletingUserLibraryFileset() {
        view = UserLibrariesFilesetTest.viewForProject(PROJECT_NAME3);
        Archive archiveInView = view.getProject(PROJECT_NAME3).getArchive(ARCHIVE_PATH3);
        archiveInView.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_1).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME3, ARCHIVE_PATH3, USER_LIBRARY_1}));
        archiveInView.getUserLibraryFileset(USER_LIBRARY_1, false).deleteUserLibraryFileset(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME3, ARCHIVE_PATH3, USER_LIBRARY_1}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_NAME3);
        Archive archiveInExplorer = explorer.getArchive(ARCHIVE_PATH3);
        archiveInExplorer.newUserLibraryFileset().selectUserLibrary(USER_LIBRARY_2).finish();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME3, "Project Archives", ARCHIVE_PATH3, USER_LIBRARY_2}));
        archiveInView.getUserLibraryFileset(USER_LIBRARY_2, false).deleteUserLibraryFileset(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_NAME3, "Project Archives", ARCHIVE_PATH3, USER_LIBRARY_2}));
    }

    private static void createUserLibrary(String userLibrary) {
        WorkbenchPreferenceDialog wd = new WorkbenchPreferenceDialog();
        wd.open();
        wd.select(new String[]{"Java", "Build Path", "User Libraries"});
        new PushButton("New...").click();
        DefaultShell libraryShell = new DefaultShell("New User Library");
        new DefaultText(0, new Matcher[0]).setText(userLibrary);
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)libraryShell));
        wd.ok();
    }
}

