/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.extensions.polling;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.IServerStatePollerType;

public class TimeoutPoller
implements IServerStatePoller {
    public static final String POLLER_ID = "org.jboss.ide.eclipse.as.core.runtime.server.processTerminatedPoller";
    private boolean expectedState;
    private long endTime;
    private IServer server;
    private IServerStatePollerType type;

    public void beginPolling(IServer server, boolean expectedState) {
        this.expectedState = expectedState;
        this.server = server;
        this.endTime = new Date().getTime() + (long)this.getTimeout();
    }

    public IServer getServer() {
        return this.server;
    }

    public void cancel(int type) {
    }

    public boolean getState() {
        if (new Date().getTime() > this.endTime) {
            return this.expectedState;
        }
        return !this.expectedState;
    }

    public boolean isComplete() {
        return new Date().getTime() > this.endTime;
    }

    public void cleanup() {
    }

    public int getTimeout() {
        if (this.expectedState) {
            return (this.getServer().getStartTimeout() - 3) * 1000;
        }
        return (this.getServer().getStopTimeout() - 3) * 1000;
    }

    public void provideCredentials(Properties properties) {
    }

    public List<String> getRequiredProperties() {
        return null;
    }

    public IServerStatePollerType getPollerType() {
        return this.type;
    }

    public void setPollerType(IServerStatePollerType type) {
        this.type = type;
    }

    public int getTimeoutBehavior() {
        if (this.expectedState) {
            return 0;
        }
        return 1;
    }
}

